package cn.quantgroup.xyqb.remote;

import cn.quantgroup.xyqb.model.JiGuangRequestParam;
import cn.quantgroup.xyqb.model.JiGuangResponseParam;
import cn.quantgroup.xyqb.remote.config.JiGuangConfiguration;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "jiGuangRemoteService", configuration = JiGuangConfiguration.class, url = "https://api.verification.jpush.cn")
public interface JiGuangRemoteService {
    @PostMapping(value = "/v1/web/loginTokenVerify", produces = "application/json")
    JiGuangResponseParam webLoginTokenVerify(@RequestBody JiGuangRequestParam param);

    @PostMapping(value = "/v1/web/h5/loginTokenVerify", produces = "application/json")
    JiGuangResponseParam h5LoginTokenVerify(@RequestBody JiGuangRequestParam param);
}
