package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.entity.ProductLoginEntity;

import java.util.List;

/**
 * Created by 11 on 2016/12/29.
 */
public interface IProductLoginService {
    ProductLoginEntity findSlaveByPloginInfo(String institutionId, String productId, Long userId);
    List<ProductLoginEntity> findSlaveByPloginInfos(String institutionId, String productId, List<Long> userId);
    List<ProductLoginEntity> findSlaveByUserId(Long userId);
    List<ProductLoginEntity> findSlaveByUserIds(List<Long> userIds);

    /**
     * @author -REYLI
     * @createTime 2021-11-17
     * @description 根据条件获取租户下用户列表
     * @param institutionId
     * @param productId
     * @return Arraylist
     */
    List<ProductLoginEntity> findProductLoginsByInstitutionIdAndProductId(String institutionId, String productId);

    ProductLoginEntity findSlaveByCustomerInfo(long customerId, String institutionId, String productId);

    ProductLoginEntity findTenantAndPhoneNo(String institutionId, String productId, String phoneNo);
}
