package cn.quantgroup.user.enums;

import lombok.Getter;

/**
 * 用户手机号修改处理状态
 * <p>
 * Date: 2019/11/5
 * Time: 下午2:11
 *
 * @author: yangrui
 */
@Getter
public enum ModifyPhoneNoProcessingStatusEnum {
    /**
     * 待人工处理
     */
    INIT(0, "待人工处理"),
    /**
     * 待用户反馈
     */
    WAIT_4_USER_FEEDBACK(1, "待用户反馈"),
    /**
     * 已反馈
     */
    DONE(2, "已反馈");

    /**
     * 类型
     */
    private int type;

    /**
     * 描述
     */
    private String desc;

    ModifyPhoneNoProcessingStatusEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDesc(int type) {
        for (ModifyPhoneNoProcessingStatusEnum modifyPhoneNoProcessingStatusEnum : ModifyPhoneNoProcessingStatusEnum.values()) {
            if (modifyPhoneNoProcessingStatusEnum.type == type) {
                return modifyPhoneNoProcessingStatusEnum.desc;
            }
        }
        return null;
    }
}
