package com.netty.server.response;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

/**
 * API 调用返回的结果对象
 *
 * @author rong yang
 */
@SuppressWarnings("serial")
@Data
public class Result<T> implements java.io.Serializable {

    /**
     * 0成功,永远默认成功
     */
    private String code = "0000";

    /**
     * 业务错误码
     */
    private String businessCode = ResultCode.SUCCESS.getCode();

    /**
     * 消息
     **/
    private String msg;

    /**
     * 详细消息
     **/
    private String detail;

    /**
     * 数据
     **/
    private T data;

    private Boolean success;

    private String traceId;

    /**
     * @param resultCode
     */
    protected void setResultCode(ResultCode resultCode) {
        this.businessCode = resultCode.getCode();
        this.msg = resultCode.getMsg();
    }

    public Result() {
        this.traceId = getTraceId();
    }

    public Result(String code, String businessCode, String msg, String detail, T data, boolean success) {
        this.code = code;
        this.businessCode = businessCode;
        this.msg = msg;
        this.detail = detail;
        this.data = data;
        this.success = success;
    }

    public static Result success() {
        Result result = new Result();
        result.setResultCode(ResultCode.SUCCESS);
        result.setData(new Object());
        return result;
    }

    public static Result supplyChainSuccess() {
        Result result = new Result();
        result.setCode(ResultCode.SUCCESS.getCode());
        result.setBusinessCode(ResultCode.SUCCESS.getCode());
        result.setSuccess(null);
        return result;
    }


    public Result<T> buildSuccess(T data) {
        this.setResultCode(ResultCode.SUCCESS);
        this.setData(data);
        return this;
    }

    public static <T> Result<T> success(T data) {
        Result result = new Result();
        result.setResultCode(ResultCode.SUCCESS);
        result.setData(data);
        return result;
    }

    public static Result failure() {
        Result result = new Result();
        result.setResultCode(ResultCode.FAILURE);
        return result;
    }

    public static Result failure(String msg) {
        Result result = new Result();
        result.setBusinessCode(ResultCode.FAILURE.getCode());
        result.setMsg(msg);
        return result;
    }

    public static Result failure(ResultCode resultCode) {
        Result result = new Result();
        result.setResultCode(resultCode);
        return result;
    }

    public static Result failure(ResultCode resultCode, String detail) {
        Result result = new Result();
        result.setResultCode(resultCode);
        result.setDetail(detail);
        return result;
    }

    public boolean isSuccess() {
        return ("0000".equals(code) || "0".equals(code));
    }

    public static String getTraceId(){
        String traceId = MDC.get("X-B3-TraceId");
        String spanId = MDC.get("X-B3-SpanId");
        if (StringUtils.isNotEmpty(traceId) && StringUtils.isNotEmpty(spanId)) {
            StringBuffer sb = new StringBuffer()
                    .append("[").append(traceId).append("-").append(spanId).append("]");
            return sb.toString();
        }
        return "";
    }
}
