package cn.quantgroup.server.impl;

import cn.quantgroup.response.Result;
import cn.quantgroup.server.IStmsServer;
import cn.quantgroup.server.StmsRemoteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.LinkedHashMap;


@Slf4j
@Component
public class StmsServerImpl implements IStmsServer {

    @Value("${stms.http}")
    private String stms;

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private StmsRemoteService stmsRemoteService;


    @Override
    public String getStmsTokenInfo(String token) {
        try {
            Result<Object> result = stmsRemoteService.getCurrentuserinfo(token);
            if (result.isSuccess()) {
                LinkedHashMap jsonData =  (LinkedHashMap) result.getData();
                return (String)jsonData.get("supplierCode");
            } else {
                throw new RuntimeException(result.getMsg());
            }
        } catch (Exception e) {
            log.error("Exception--{}", e.getMessage());
        }
        return null;
    }
}
