package cn.quantgroup;


import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import cn.quantgroup.server.TcpServer;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;


/**
 */
@ComponentScan(basePackages = { "cn.quantgroup.*"})
@EnableFeignClients(basePackages = {"cn.quantgroup.*"})
@SpringBootApplication
@RequiredArgsConstructor
@EnableApolloConfig
@EnableDiscoveryClient
public class NettyServerApplication implements ApplicationRunner {

    private final TcpServer tcpServer;



    public static void main(String[] args) {
        SpringApplication.run(NettyServerApplication.class, args);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        tcpServer.start();
    }

}
