package cn.quantgroup.server;

import cn.quantgroup.response.Result;
import feign.Headers;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;

@FeignClient(name = "stmsRemoteService", url = "${stms.http}")
public interface StmsRemoteService {
    @Headers("Content-Type:application/json")
    @PostMapping(value = "/v2/oauth/currentuserinfo")
    Result<String> getCurrentuserinfo(@RequestHeader("Access-Token") String accessToken);
}
