package cn.quantgroup.config;

import cn.quantgroup.model.MsgAgreement;
import cn.quantgroup.server.CacheService;
import com.alibaba.fastjson.JSON;
import cn.quantgroup.utils.CacheUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


/**
 * redis订阅消息处理实现类
 *
 * @author jie
 */
@Slf4j
@Component
public class MsgReceiver extends MessageListenerAdapter {

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Resource
    private CacheService cacheService;

    /**
     * 接收redis推送的消息如果当前服务连接的有此设备就推送消息
     *
     * @param message 消息
     */
    @Override
    public void onMessage(Message message, byte[] pattern) {
        String msg = redisTemplate.getStringSerializer().deserialize(message.getBody());
        String topic = redisTemplate.getStringSerializer().deserialize(message.getChannel());
        log.info("来自" + topic + "的消息：" + msg);

        MsgAgreement msgAgreement = JSON.parseObject(msg, MsgAgreement.class);
        String toChannelId = msgAgreement.getToChannelId();
        Channel channel = CacheUtil.cacheChannel.get(toChannelId);
        if (null == channel) {
            cacheService.getRedisUtil().remove(toChannelId);
            return;
        }
        channel.writeAndFlush(new TextWebSocketFrame(msgAgreement.getContent()));
    }
}
