package cn.quantgroup.utils;

import lombok.extern.slf4j.Slf4j;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by tums on 2015/11/30.
 */
@Slf4j
public final class Md5Utils {

    public static String build(String content) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest
                    .getInstance("md5");
        } catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), e);
            return null;
        }
        messageDigest.update(content.getBytes());
        byte[] domain = messageDigest.digest();
        StringBuilder md5StrBuff = new StringBuilder();
        // converting domain to String
        for (int i = 0; i < domain.length; i++) {
            if (Integer.toHexString(0xFF & domain[i]).length() == 1) {
                md5StrBuff.append("0").append(
                        Integer.toHexString(0xFF & domain[i]));
            } else {
                md5StrBuff.append(Integer.toHexString(0xFF & domain[i]));
            }
        }
        return md5StrBuff.toString();
    }

    public static String MD5Encode(String origin) {
        String ret = null;
        try {
            ret = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            ret = byteArrayToHexString(md.digest(ret.getBytes()));
        } catch (Exception e) {
        }
        return ret;
    }

    private final static String[] hexDigits = { "0", "1", "2", "3", "4", "5",
            "6", "7", "8", "9", "a", "b", "c", "d", "e", "f" };

    private static String byteArrayToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            sb.append(byteToHexString(b));
        }
        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0)
            n = 256 + n;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }


}
