package com.netty.server.server.impl;

import com.alibaba.fastjson.JSONObject;
import com.netty.server.response.Result;
import com.netty.server.server.IStmsServer;
import com.netty.server.server.StmsRemoteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;


@Slf4j
@Component
public class StmsServerImpl implements IStmsServer {

    @Value("${stms.http}")
    private String stms;

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private StmsRemoteService stmsRemoteService;


    @Override
    public String getStmsTokenInfo(String token) {
        try {
            Result<String> result = stmsRemoteService.getCurrentuserinfo(token);
            if (result.isSuccess()) {
                JSONObject jsonData = JSONObject.parseObject(result.getData().toString());
                return jsonData.getString("supplierCode");
            }
        } catch (Exception e) {
            log.error("Exception--{}", e.getMessage());
        }
        return null;
    }
}
