package com.netty.server.server;

import feign.Headers;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import com.netty.server.response.Result;

@FeignClient(name = "stmsRemoteService", url = "${stms.http}")
public interface StmsRemoteService {
    @Headers("Content-Type:application/json")
    @PostMapping(value = "/v2/oauth/currentuserinfo")
    Result<String> getCurrentuserinfo(@RequestHeader("Access-Token") String accessToken);
}
