package com.netty.server;


import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.netty.server.server.TcpServer;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;


/**
 * @author qiding
 */
@ComponentScan(basePackages = {"com.netty.server.*"})
@EnableFeignClients(basePackages = {"com.netty.*"})
@SpringBootApplication
@RequiredArgsConstructor
@EnableApolloConfig
@EnableDiscoveryClient
public class NettyServerApplication implements ApplicationRunner {

    private final TcpServer tcpServer;



    public static void main(String[] args) {
        SpringApplication.run(NettyServerApplication.class, args);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        tcpServer.start();
    }

}
