package com.netty.server.config;

import com.google.common.collect.Lists;
import feign.Contract;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;

import javax.annotation.PostConstruct;
import java.util.List;

@Configuration
public class FeignConfig {
//    @Bean
//    public Encoder encoder(){
//        return new MyEncoder();
//    }


    List<HttpMessageConverter<?>> converters = Lists.newArrayList();
    @PostConstruct
    public void init(){
        MessageConverter wxConverter = new MessageConverter();
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(wxConverter);
        this.converters = httpMessageConverters.getConverters();
    }

    @Bean
    Logger.Level feignLevel() {
        return Logger.Level.FULL;
    }


    @Bean
    public Contract contract() {
        return new SpringMvcContract();
    }

    @Bean
    public Encoder springEncoder(@Autowired  ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SpringEncoder(messageConverters);
    }

    /**
     * 注入新的Decoder Feign将自动 替换解决微信返回参数为[text/plain] 无法转化为json
     * 微信虽然接口返回为JSON格式数据但却将数据表示为了[text/plain]导致Feign没有采用JSON解析器来解析，从而无法将响应数据转化为对应的POJO对象；
     */
    @Bean
    public Decoder feignDecoder() {
        MessageConverter wxConverter = new MessageConverter();
        ObjectFactory<HttpMessageConverters> objectFactory = () -> new HttpMessageConverters(wxConverter);
        return new SpringDecoder(objectFactory);
    }

//    @Bean
//    public Decoder feignDecoder() {
//
//        /**
//         * 改动原因：  压测时，feign 会有性能问题
//         *
//         * addDefaultConverters 为true, feign 执行decoder 每次都会重新初始化 默认的 decoder
//         * 所以：提前把 自定义的convert 和 默认的convert  处理好后，不再处理默认添加
//         *
//         * https://blog.csdn.net/weixin_35762553/article/details/112087522
//         */
//        ObjectFactory objectFactory = () -> new HttpMessageConverters(false, converters);
//        return new ResponseEntityDecoder(new SpringDecoder(objectFactory));
//    }
//
}