package com.netty.server.Controller;

import com.netty.server.handler.ChannelHandlerPool;
import com.netty.server.model.MsgAgreement;
import com.netty.server.server.CacheService;
import com.netty.server.utils.CacheUtil;
import com.netty.server.utils.MsgUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.AttributeKey;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/message")
public class IndexController {
    @Resource
    private CacheService cacheService;

    @PostMapping("/send")
    public String send2User(@RequestParam(value = "token") String token, @RequestParam(value = "data") String data) {
        String channelIds = cacheService.getRedisUtil().getChannelRelation(token);
        if (null == channelIds) {
            return "商户" + token + "不在线！";
        }
        String[] channelIdlist = channelIds.split(",");
        for (String channelId : channelIdlist) {
            Channel ch = CacheUtil.cacheChannel.get(channelId);
            MsgAgreement msgAgreement = new MsgAgreement();
            msgAgreement.setToChannelId(channelId);
            msgAgreement.setContent(data);
            if (ch != null) {
                ch.writeAndFlush(new TextWebSocketFrame(MsgUtil.obj2Json(msgAgreement)));
                return "success";
            }
            //如果为NULL则接收消息的用户不在本服务端，需要push消息给全局
            cacheService.push(msgAgreement);
        }
        return "success";
    }

    /**
     * 根据用户id查找channel
     *
     * @param name
     * @return
     */
    public List<Channel> getChannelByName(String name) {
        AttributeKey<String> key = AttributeKey.valueOf("user");
        return ChannelHandlerPool.channelGroup.stream().filter(channel -> channel.attr(key).get().equals(name))
                .collect(Collectors.toList());
    }

}
