package com.netty.server.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 用户管道信息；记录某个用户分配到某个服务端
 *
 * @author jie
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeviceChannelInfo {
    /**
     * 服务端IP
     */
    private String ip;
    /**
     * 服务端port
     */
    private int port;
    /**
     * channelId
     */
    private String channelId;
    /**
     * 链接时间
     */
    private Date linkDate;

    /**
     * 关联信息
     */
    private String relationInfo;
}
