export const fields = {
  "ga:userType": { section: "User", can_filter: true, can_breakout: true },
  "ga:sessionCount": { section: "User", can_filter: true, can_breakout: true },
  "ga:daysSinceLastSession": {
    section: "User",
    can_filter: true,
    can_breakout: true,
  },
  "ga:userDefinedValue": {
    section: "User",
    can_filter: true,
    can_breakout: true,
  },
  "ga:users": { section: "User", can_filter: true, can_breakout: false },
  "ga:newUsers": { section: "User", can_filter: true, can_breakout: false },
  "ga:percentNewSessions": {
    section: "User",
    can_filter: true,
    can_breakout: false,
  },
  "ga:1dayUsers": { section: "User", can_filter: true, can_breakout: false },
  "ga:7dayUsers": { section: "User", can_filter: true, can_breakout: false },
  "ga:14dayUsers": { section: "User", can_filter: true, can_breakout: false },
  "ga:30dayUsers": { section: "User", can_filter: true, can_breakout: false },
  "ga:sessionDurationBucket": {
    section: "Session",
    can_filter: true,
    can_breakout: true,
  },
  "ga:sessions": { section: "Session", can_filter: true, can_breakout: false },
  "ga:bounces": { section: "Session", can_filter: true, can_breakout: false },
  "ga:bounceRate": {
    section: "Session",
    can_filter: true,
    can_breakout: false,
  },
  "ga:sessionDuration": {
    section: "Session",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgSessionDuration": {
    section: "Session",
    can_filter: true,
    can_breakout: false,
  },
  "ga:referralPath": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:fullReferrer": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:campaign": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:source": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:medium": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:sourceMedium": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:keyword": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adContent": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:socialNetwork": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:hasSocialSourceReferral": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:organicSearches": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adGroup": { section: "Adwords", can_filter: true, can_breakout: true },
  "ga:adSlot": { section: "Adwords", can_filter: true, can_breakout: true },
  "ga:adDistributionNetwork": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adMatchType": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adKeywordMatchType": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adMatchedQuery": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adPlacementDomain": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adPlacementUrl": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adFormat": { section: "Adwords", can_filter: true, can_breakout: true },
  "ga:adTargetingType": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adTargetingOption": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adDisplayUrl": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adDestinationUrl": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adwordsCustomerID": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adwordsCampaignID": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adwordsAdGroupID": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adwordsCreativeID": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adwordsCriteriaID": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:impressions": {
    section: "Adwords",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adClicks": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:adCost": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:CPM": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:CPC": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:CTR": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:costPerTransaction": {
    section: "Adwords",
    can_filter: true,
    can_breakout: false,
  },
  "ga:costPerGoalConversion": {
    section: "Adwords",
    can_filter: true,
    can_breakout: false,
  },
  "ga:costPerConversion": {
    section: "Adwords",
    can_filter: true,
    can_breakout: false,
  },
  "ga:RPC": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:ROAS": { section: "Adwords", can_filter: true, can_breakout: false },
  "ga:adQueryWordCount": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:goalCompletionLocation": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:goalPreviousStep1": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:goalPreviousStep2": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:goalPreviousStep3": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:goalXXStarts": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalStartsAll": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalXXCompletions": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalCompletionsAll": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalXXValue": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalValueAll": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalValuePerSession": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalXXConversionRate": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalConversionRateAll": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalXXAbandons": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalAbandonsAll": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalXXAbandonRate": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalAbandonRateAll": {
    section: "Goal Conversions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:browser": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:browserVersion": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:operatingSystem": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:operatingSystemVersion": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:mobileDeviceBranding": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:mobileDeviceModel": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:mobileInputSelector": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:mobileDeviceInfo": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:mobileDeviceMarketingName": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:deviceCategory": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:continent": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:subContinent": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:country": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:region": { section: "Geo Network", can_filter: true, can_breakout: true },
  "ga:metro": { section: "Geo Network", can_filter: true, can_breakout: true },
  "ga:city": { section: "Geo Network", can_filter: true, can_breakout: true },
  "ga:latitude": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:longitude": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:networkDomain": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:networkLocation": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:flashVersion": {
    section: "System",
    can_filter: true,
    can_breakout: true,
  },
  "ga:javaEnabled": { section: "System", can_filter: true, can_breakout: true },
  "ga:language": { section: "System", can_filter: true, can_breakout: true },
  "ga:screenColors": {
    section: "System",
    can_filter: true,
    can_breakout: true,
  },
  "ga:sourcePropertyDisplayName": {
    section: "System",
    can_filter: true,
    can_breakout: true,
  },
  "ga:sourcePropertyTrackingId": {
    section: "System",
    can_filter: true,
    can_breakout: true,
  },
  "ga:screenResolution": {
    section: "System",
    can_filter: true,
    can_breakout: true,
  },
  "ga:hostname": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pagePath": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pagePathLevel1": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pagePathLevel2": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pagePathLevel3": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pagePathLevel4": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pageTitle": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:landingPagePath": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:secondPagePath": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:exitPagePath": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:previousPagePath": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pageDepth": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:pageValue": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:entrances": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:entranceRate": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:pageviews": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:pageviewsPerSession": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:contentGroupUniqueViewsXX": {
    section: "Content Grouping",
    can_filter: true,
    can_breakout: false,
  },
  "ga:uniquePageviews": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:timeOnPage": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgTimeOnPage": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:exits": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:exitRate": {
    section: "Page Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchUsed": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchKeyword": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchKeywordRefinement": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchCategory": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchStartPage": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchDestinationPage": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchAfterDestinationPage": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: true,
  },
  "ga:searchResultViews": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchUniques": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgSearchResultViews": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchSessions": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:percentSessionsWithSearch": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchDepth": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgSearchDepth": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchRefinements": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:percentSearchRefinements": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchDuration": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgSearchDuration": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchExits": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchExitRate": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchGoalXXConversionRate": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:searchGoalConversionRateAll": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:goalValueAllPerSearch": {
    section: "Internal Search",
    can_filter: true,
    can_breakout: false,
  },
  "ga:pageLoadTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:pageLoadSample": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgPageLoadTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:domainLookupTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgDomainLookupTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:pageDownloadTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgPageDownloadTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:redirectionTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgRedirectionTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:serverConnectionTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgServerConnectionTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:serverResponseTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgServerResponseTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:speedMetricsSample": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:domInteractiveTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgDomInteractiveTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:domContentLoadedTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgDomContentLoadedTime": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:domLatencyMetricsSample": {
    section: "Site Speed",
    can_filter: true,
    can_breakout: false,
  },
  "ga:appInstallerId": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:appVersion": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:appName": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:appId": { section: "App Tracking", can_filter: true, can_breakout: true },
  "ga:screenName": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:screenDepth": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:landingScreenName": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:exitScreenName": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:screenviews": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:uniqueScreenviews": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:screenviewsPerSession": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:timeOnScreen": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgScreenviewDuration": {
    section: "App Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:eventCategory": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:eventAction": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:eventLabel": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: true,
  },
  "ga:totalEvents": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:uniqueDimensionCombinations": {
    section: "Session",
    can_filter: true,
    can_breakout: false,
  },
  "ga:eventValue": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgEventValue": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:sessionsWithEvent": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:eventsPerSessionWithEvent": {
    section: "Event Tracking",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionId": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:affiliation": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:sessionsToTransaction": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:daysToTransaction": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productSku": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productName": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productCategory": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:currencyCode": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:transactions": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionsPerSession": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionRevenue": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:revenuePerTransaction": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionRevenuePerSession": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionShipping": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionTax": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:totalValue": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:itemQuantity": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:uniquePurchases": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:revenuePerItem": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:itemRevenue": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:itemsPerPurchase": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:localTransactionRevenue": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:localTransactionShipping": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:localTransactionTax": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:localItemRevenue": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:socialInteractionNetwork": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:socialInteractionAction": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:socialInteractionNetworkAction": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:socialInteractionTarget": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:socialEngagementType": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:socialInteractions": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:uniqueSocialInteractions": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:socialInteractionsPerSession": {
    section: "Social Interactions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:userTimingCategory": {
    section: "User Timings",
    can_filter: true,
    can_breakout: true,
  },
  "ga:userTimingLabel": {
    section: "User Timings",
    can_filter: true,
    can_breakout: true,
  },
  "ga:userTimingVariable": {
    section: "User Timings",
    can_filter: true,
    can_breakout: true,
  },
  "ga:userTimingValue": {
    section: "User Timings",
    can_filter: true,
    can_breakout: false,
  },
  "ga:userTimingSample": {
    section: "User Timings",
    can_filter: true,
    can_breakout: false,
  },
  "ga:avgUserTimingValue": {
    section: "User Timings",
    can_filter: true,
    can_breakout: false,
  },
  "ga:exceptionDescription": {
    section: "Exceptions",
    can_filter: true,
    can_breakout: true,
  },
  "ga:exceptions": {
    section: "Exceptions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:exceptionsPerScreenview": {
    section: "Exceptions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:fatalExceptions": {
    section: "Exceptions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:fatalExceptionsPerScreenview": {
    section: "Exceptions",
    can_filter: true,
    can_breakout: false,
  },
  "ga:experimentId": {
    section: "Content Experiments",
    can_filter: true,
    can_breakout: true,
  },
  "ga:experimentVariant": {
    section: "Content Experiments",
    can_filter: true,
    can_breakout: true,
  },
  "ga:dimensionXX": {
    section: "Custom Variables or Columns",
    can_filter: true,
    can_breakout: true,
  },
  "ga:customVarNameXX": {
    section: "Custom Variables or Columns",
    can_filter: true,
    can_breakout: true,
  },
  "ga:metricXX": {
    section: "Custom Variables or Columns",
    can_filter: true,
    can_breakout: false,
  },
  "ga:customVarValueXX": {
    section: "Custom Variables or Columns",
    can_filter: true,
    can_breakout: true,
  },
  "ga:date": { section: "Time", can_filter: true, can_breakout: true },
  "ga:year": { section: "Time", can_filter: true, can_breakout: true },
  "ga:month": { section: "Time", can_filter: true, can_breakout: true },
  "ga:week": { section: "Time", can_filter: true, can_breakout: true },
  "ga:day": { section: "Time", can_filter: true, can_breakout: true },
  "ga:hour": { section: "Time", can_filter: true, can_breakout: true },
  "ga:minute": { section: "Time", can_filter: true, can_breakout: true },
  "ga:nthMonth": { section: "Time", can_filter: true, can_breakout: true },
  "ga:nthWeek": { section: "Time", can_filter: true, can_breakout: true },
  "ga:nthDay": { section: "Time", can_filter: true, can_breakout: true },
  "ga:nthMinute": { section: "Time", can_filter: true, can_breakout: true },
  "ga:dayOfWeek": { section: "Time", can_filter: true, can_breakout: true },
  "ga:dayOfWeekName": { section: "Time", can_filter: true, can_breakout: true },
  "ga:dateHour": { section: "Time", can_filter: true, can_breakout: true },
  "ga:yearMonth": { section: "Time", can_filter: true, can_breakout: true },
  "ga:yearWeek": { section: "Time", can_filter: true, can_breakout: true },
  "ga:isoWeek": { section: "Time", can_filter: true, can_breakout: true },
  "ga:isoYear": { section: "Time", can_filter: true, can_breakout: true },
  "ga:isoYearIsoWeek": {
    section: "Time",
    can_filter: true,
    can_breakout: true,
  },
  // 'ga:dcmClickAd': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickAdId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickAdType': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickAdTypeId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickAdvertiser': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickAdvertiserId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCampaign': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCampaignId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCreativeId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCreative': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickRenderingId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCreativeType': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCreativeTypeId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickCreativeVersion': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickSite': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickSiteId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickSitePlacement': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickSitePlacementId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmClickSpotId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightActivity': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightActivityAndGroup': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightActivityGroup': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightActivityGroupId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightActivityId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightAdvertiserId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightSpotId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAd': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAdId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAdType': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAdTypeId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAdvertiser': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAdvertiserId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventAttributionType': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCampaign': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCampaignId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCreativeId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCreative': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventRenderingId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCreativeType': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCreativeTypeId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventCreativeVersion': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventSite': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventSiteId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventSitePlacement': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventSitePlacementId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmLastEventSpotId': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: true },
  // 'ga:dcmFloodlightQuantity': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmFloodlightRevenue': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  "ga:landingContentGroupXX": {
    section: "Content Grouping",
    can_filter: true,
    can_breakout: true,
  },
  "ga:previousContentGroupXX": {
    section: "Content Grouping",
    can_filter: true,
    can_breakout: true,
  },
  "ga:contentGroupXX": {
    section: "Content Grouping",
    can_filter: true,
    can_breakout: true,
  },
  "ga:userAgeBracket": {
    section: "Audience",
    can_filter: true,
    can_breakout: true,
  },
  "ga:userGender": {
    section: "Audience",
    can_filter: true,
    can_breakout: true,
  },
  "ga:interestOtherCategory": {
    section: "Audience",
    can_filter: true,
    can_breakout: true,
  },
  "ga:interestAffinityCategory": {
    section: "Audience",
    can_filter: true,
    can_breakout: true,
  },
  "ga:interestInMarketCategory": {
    section: "Audience",
    can_filter: true,
    can_breakout: true,
  },
  "ga:adsenseRevenue": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseAdUnitsViewed": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseAdsViewed": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseAdsClicks": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsensePageImpressions": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseCTR": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseECPM": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseExits": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseViewableImpressionPercent": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  "ga:adsenseCoverage": {
    section: "Adsense",
    can_filter: true,
    can_breakout: false,
  },
  // 'ga:adxImpressions': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxCoverage': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxMonetizedPageviews': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxImpressionsPerSession': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxViewableImpressionsPercent': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxClicks': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxCTR': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxRevenue': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxRevenuePer1000Sessions': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:adxECPM': { section: 'Ad Exchange', can_filter: true, can_breakout: false },
  // 'ga:dfpImpressions': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpCoverage': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpMonetizedPageviews': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpImpressionsPerSession': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpViewableImpressionsPercent': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpClicks': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpCTR': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpRevenue': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpRevenuePer1000Sessions': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:dfpECPM': { section: 'DoubleClick for Publishers', can_filter: true, can_breakout: false },
  // 'ga:backfillImpressions': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillCoverage': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillMonetizedPageviews': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillImpressionsPerSession': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillViewableImpressionsPercent': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillClicks': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillCTR': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillRevenue': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillRevenuePer1000Sessions': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  // 'ga:backfillECPM': { section: 'DoubleClick for Publishers Backfill', can_filter: true, can_breakout: false },
  "ga:acquisitionCampaign": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:acquisitionMedium": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:acquisitionSource": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:acquisitionSourceMedium": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:acquisitionTrafficChannel": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:browserSize": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  "ga:campaignCode": {
    section: "Traffic Sources",
    can_filter: true,
    can_breakout: true,
  },
  "ga:channelGrouping": {
    section: "Channel Grouping",
    can_filter: true,
    can_breakout: true,
  },
  "ga:checkoutOptions": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:cityId": { section: "Geo Network", can_filter: true, can_breakout: true },
  "ga:cohort": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: true,
  },
  "ga:cohortNthDay": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: true,
  },
  "ga:cohortNthMonth": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: true,
  },
  "ga:cohortNthWeek": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: true,
  },
  "ga:continentId": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:correlationModelId": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:countryIsoCode": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:dataSource": {
    section: "Platform or Device",
    can_filter: true,
    can_breakout: true,
  },
  // 'ga:dbmClickAdvertiser': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickAdvertiserId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickCreativeId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickExchange': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickExchangeId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickInsertionOrder': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickInsertionOrderId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickLineItem': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickLineItemId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickSite': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmClickSiteId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventAdvertiser': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventAdvertiserId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventCreativeId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventExchange': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventExchangeId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventInsertionOrder': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventInsertionOrderId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventLineItem': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventLineItemId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventSite': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dbmLastEventSiteId': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: true },
  // 'ga:dsAdGroup': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsAdGroupId': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsAdvertiser': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsAdvertiserId': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsAgency': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsAgencyId': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsCampaign': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsCampaignId': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsEngineAccount': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsEngineAccountId': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsKeyword': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  // 'ga:dsKeywordId': { section: 'DoubleClick Search', can_filter: true, can_breakout: true },
  "ga:internalPromotionCreative": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:internalPromotionId": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:internalPromotionName": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:internalPromotionPosition": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:isTrueViewVideoAd": {
    section: "Adwords",
    can_filter: true,
    can_breakout: true,
  },
  "ga:metroId": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:nthHour": { section: "Time", can_filter: true, can_breakout: true },
  "ga:orderCouponCode": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productBrand": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productCategoryHierarchy": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productCategoryLevelXX": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productCouponCode": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productListName": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productListPosition": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:productVariant": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:queryProductId": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:queryProductName": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:queryProductVariation": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:regionId": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:regionIsoCode": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:relatedProductId": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:relatedProductName": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:relatedProductVariation": {
    section: "Related Products",
    can_filter: true,
    can_breakout: true,
  },
  "ga:shoppingStage": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: true,
  },
  "ga:subContinentCode": {
    section: "Geo Network",
    can_filter: true,
    can_breakout: true,
  },
  "ga:buyToDetailRate": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:calcMetric_<NAME>": {
    section: "Custom Variables or Columns",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cartToDetailRate": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortActiveUsers": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortAppviewsPerUser": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortAppviewsPerUserWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortGoalCompletionsPerUser": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortGoalCompletionsPerUserWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortPageviewsPerUser": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortPageviewsPerUserWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortRetentionRate": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortRevenuePerUser": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortRevenuePerUserWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortSessionDurationPerUser": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortSessionDurationPerUserWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortSessionsPerUser": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortSessionsPerUserWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortTotalUsers": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:cohortTotalUsersWithLifetimeCriteria": {
    section: "Lifetime Value and Cohorts",
    can_filter: true,
    can_breakout: false,
  },
  "ga:correlationScore": {
    section: "Related Products",
    can_filter: true,
    can_breakout: false,
  },
  // 'ga:dbmCPA': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmCPC': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmCPM': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmCTR': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmClicks': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmConversions': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmCost': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmImpressions': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dbmROAS': { section: 'DoubleClick Bid Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmCPC': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmCTR': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmClicks': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmCost': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmImpressions': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmROAS': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dcmRPC': { section: 'DoubleClick Campaign Manager', can_filter: true, can_breakout: false },
  // 'ga:dsCPC': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsCTR': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsClicks': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsCost': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsImpressions': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsProfit': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsReturnOnAdSpend': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  // 'ga:dsRevenuePerClick': { section: 'DoubleClick Search', can_filter: true, can_breakout: false },
  "ga:hits": { section: "Session", can_filter: true, can_breakout: false },
  "ga:internalPromotionCTR": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:internalPromotionClicks": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:internalPromotionViews": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:localProductRefundAmount": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:localRefundAmount": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productAddsToCart": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productCheckouts": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productDetailViews": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productListCTR": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productListClicks": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productListViews": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productRefundAmount": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productRefunds": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productRemovesFromCart": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:productRevenuePerPurchase": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:quantityAddedToCart": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:quantityCheckedOut": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:quantityRefunded": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:quantityRemovedFromCart": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:queryProductQuantity": {
    section: "Related Products",
    can_filter: true,
    can_breakout: false,
  },
  "ga:refundAmount": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:relatedProductQuantity": {
    section: "Related Products",
    can_filter: true,
    can_breakout: false,
  },
  "ga:revenuePerUser": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:sessionsPerUser": {
    section: "User",
    can_filter: true,
    can_breakout: false,
  },
  "ga:totalRefunds": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
  "ga:transactionsPerUser": {
    section: "Ecommerce",
    can_filter: true,
    can_breakout: false,
  },
};

export const metrics = [
  {
    id: "ga:users",
    name: "Users",
    description: "The total number of users for the requested time period.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:newUsers",
    name: "New Users",
    description:
      "The number of users whose session was marked as a first-time session.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:percentNewSessions",
    name: "% New Sessions",
    description:
      "The percentage of sessions by users who had never visited the property before.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:1dayUsers",
    name: "1 Day Active Users",
    description:
      "Total number of 1-day active users for each day in the requested time period. At least one of ga:nthDay, ga:date, or ga:day must be specified as a dimension to query this metric. For a given date, the returned value will be the total number of unique users for the 1-day period ending on the given date.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:7dayUsers",
    name: "7 Day Active Users",
    description:
      "Total number of 7-day active users for each day in the requested time period. At least one of ga:nthDay, ga:date, or ga:day must be specified as a dimension to query this metric. For a given date, the returned value will be the total number of unique users for the 7-day period ending on the given date.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:14dayUsers",
    name: "14 Day Active Users",
    description:
      "Total number of 14-day active users for each day in the requested time period. At least one of ga:nthDay, ga:date, or ga:day must be specified as a dimension to query this metric. For a given date, the returned value will be the total number of unique users for the 14-day period ending on the given date.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:30dayUsers",
    name: "30 Day Active Users",
    description:
      "Total number of 30-day active users for each day in the requested time period. At least one of ga:nthDay, ga:date, or ga:day must be specified as a dimension to query this metric. For a given date, the returned value will be the total number of unique users for the 30-day period ending on the given date.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:sessions",
    name: "Sessions",
    description: "The total number of sessions.",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:bounces",
    name: "Bounces",
    description:
      "The total number of single page (or single interaction hit) sessions for the property.",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:bounceRate",
    name: "Bounce Rate",
    description:
      "The percentage of single-page session (i.e., session in which the person left the property from the first page).",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:sessionDuration",
    name: "Session Duration",
    description: "Total duration (in seconds) of users' sessions.",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:avgSessionDuration",
    name: "Avg. Session Duration",
    description: "The average duration (in seconds) of users' sessions.",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:organicSearches",
    name: "Organic Searches",
    description:
      "The number of organic searches happened in a session. This metric is search engine agnostic.",
    section: "Traffic Sources",
    is_active: true,
  },
  {
    id: "ga:impressions",
    name: "Impressions",
    description: "Total number of campaign impressions.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:adClicks",
    name: "Clicks",
    description:
      "Total number of times users have clicked on an ad to reach the property.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:adCost",
    name: "Cost",
    description:
      "Derived cost for the advertising campaign. Its currency is the one you set in the AdWords account.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:CPM",
    name: "CPM",
    description: "Cost per thousand impressions.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:CPC",
    name: "CPC",
    description: "Cost to advertiser per click.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:CTR",
    name: "CTR",
    description:
      "Click-through-rate for the ad. This is equal to the number of clicks divided by the number of impressions for the ad (e.g., how many times users clicked on one of the ads where that ad appeared).",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:costPerTransaction",
    name: "Cost per Transaction",
    description: "The cost per transaction for the property.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:costPerGoalConversion",
    name: "Cost per Goal Conversion",
    description: "The cost per goal conversion for the property.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:costPerConversion",
    name: "Cost per Conversion",
    description:
      "The cost per conversion (including ecommerce and goal conversions) for the property.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:RPC",
    name: "RPC",
    description:
      "RPC or revenue-per-click, the average revenue (from ecommerce sales and/or goal value) you received for each click on one of the search ads.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:ROAS",
    name: "ROAS",
    description:
      "Return On Ad Spend (ROAS) is the total transaction revenue and goal value divided by derived advertising cost.",
    section: "Adwords",
    is_active: true,
  },
  {
    id: "ga:goalXXStarts",
    name: "Goal XX Starts",
    description: "The total number of starts for the requested goal number.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalStartsAll",
    name: "Goal Starts",
    description: "Total number of starts for all goals defined in the profile.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalXXCompletions",
    name: "Goal XX Completions",
    description:
      "The total number of completions for the requested goal number.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalCompletionsAll",
    name: "Goal Completions",
    description:
      "Total number of completions for all goals defined in the profile.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalXXValue",
    name: "Goal XX Value",
    description: "The total numeric value for the requested goal number.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalValueAll",
    name: "Goal Value",
    description: "Total numeric value for all goals defined in the profile.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalValuePerSession",
    name: "Per Session Goal Value",
    description: "The average goal value of a session.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalXXConversionRate",
    name: "Goal XX Conversion Rate",
    description:
      "Percentage of sessions resulting in a conversion to the requested goal number.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalConversionRateAll",
    name: "Goal Conversion Rate",
    description:
      "The percentage of sessions which resulted in a conversion to at least one of the goals.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalXXAbandons",
    name: "Goal XX Abandoned Funnels",
    description:
      "The number of times users started conversion activity on the requested goal number without actually completing it.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalAbandonsAll",
    name: "Abandoned Funnels",
    description:
      "The overall number of times users started goals without actually completing them.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalXXAbandonRate",
    name: "Goal XX Abandonment Rate",
    description: "The rate at which the requested goal number was abandoned.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:goalAbandonRateAll",
    name: "Total Abandonment Rate",
    description: "Goal abandonment rate.",
    section: "Goal Conversions",
    is_active: true,
  },
  {
    id: "ga:pageValue",
    name: "Page Value",
    description:
      "The average value of this page or set of pages, which is equal to (ga:transactionRevenue + ga:goalValueAll) / ga:uniquePageviews.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:entrances",
    name: "Entrances",
    description:
      "The number of entrances to the property measured as the first pageview in a session, typically used with landingPagePath.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:entranceRate",
    name: "Entrances / Pageviews",
    description:
      "The percentage of pageviews in which this page was the entrance.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:pageviews",
    name: "Pageviews",
    description: "The total number of pageviews for the property.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:pageviewsPerSession",
    name: "Pages / Session",
    description:
      "The average number of pages viewed during a session, including repeated views of a single page.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:contentGroupUniqueViewsXX",
    name: "Unique Views XX",
    description:
      "The number of unique content group views. Content group views in different sessions are counted as unique content group views. Both the pagePath and pageTitle are used to determine content group view uniqueness.",
    section: "Content Grouping",
    is_active: true,
  },
  {
    id: "ga:uniquePageviews",
    name: "Unique Pageviews",
    description:
      "Unique Pageviews is the number of sessions during which the specified page was viewed at least once. A unique pageview is counted for each page URL + page title combination.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:timeOnPage",
    name: "Time on Page",
    description:
      "Time (in seconds) users spent on a particular page, calculated by subtracting the initial view time for a particular page from the initial view time for a subsequent page. This metric does not apply to exit pages of the property.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:avgTimeOnPage",
    name: "Avg. Time on Page",
    description:
      "The average time users spent viewing this page or a set of pages.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:exits",
    name: "Exits",
    description: "The number of exits from the property.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:exitRate",
    name: "% Exit",
    description:
      "The percentage of exits from the property that occurred out of the total pageviews.",
    section: "Page Tracking",
    is_active: true,
  },
  {
    id: "ga:searchResultViews",
    name: "Results Pageviews",
    description: "The number of times a search result page was viewed.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchUniques",
    name: "Total Unique Searches",
    description:
      'Total number of unique keywords from internal searches within a session. For example, if "shoes" was searched for 3 times in a session, it would be counted only once.',
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:avgSearchResultViews",
    name: "Results Pageviews / Search",
    description:
      "The average number of times people viewed a page as a result of a search.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchSessions",
    name: "Sessions with Search",
    description:
      "The total number of sessions that included an internal search.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:percentSessionsWithSearch",
    name: "% Sessions with Search",
    description: "The percentage of sessions with search.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchDepth",
    name: "Search Depth",
    description:
      "The total number of subsequent page views made after a use of the site's internal search feature.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:avgSearchDepth",
    name: "Average Search Depth",
    description:
      "The average number of pages people viewed after performing a search.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchRefinements",
    name: "Search Refinements",
    description:
      'The total number of times a refinement (transition) occurs between internal keywords search within a session. For example, if the sequence of keywords is "shoes", "shoes", "pants", "pants", this metric will be one because the transition between "shoes" and "pants" is different.',
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:percentSearchRefinements",
    name: "% Search Refinements",
    description:
      "The percentage of the number of times a refinement (i.e., transition) occurs between internal keywords search within a session.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchDuration",
    name: "Time after Search",
    description:
      "The session duration when the site's internal search feature is used.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:avgSearchDuration",
    name: "Time after Search",
    description:
      "The average time (in seconds) users, after searching, spent on the property.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchExits",
    name: "Search Exits",
    description:
      "The number of exits on the site that occurred following a search result from the site's internal search feature.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchExitRate",
    name: "% Search Exits",
    description:
      "The percentage of searches that resulted in an immediate exit from the property.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchGoalXXConversionRate",
    name: "Site Search Goal XX Conversion Rate",
    description:
      "The percentage of search sessions (i.e., sessions that included at least one search) which resulted in a conversion to the requested goal number.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:searchGoalConversionRateAll",
    name: "Site Search Goal Conversion Rate",
    description:
      "The percentage of search sessions (i.e., sessions that included at least one search) which resulted in a conversion to at least one of the goals.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:goalValueAllPerSearch",
    name: "Per Search Goal Value",
    description: "The average goal value of a search.",
    section: "Internal Search",
    is_active: true,
  },
  {
    id: "ga:pageLoadTime",
    name: "Page Load Time (ms)",
    description:
      "Total time (in milliseconds), from pageview initiation (e.g., a click on a page link) to page load completion in the browser, the pages in the sample set take to load.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:pageLoadSample",
    name: "Page Load Sample",
    description:
      "The sample set (or count) of pageviews used to calculate the average page load time.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgPageLoadTime",
    name: "Avg. Page Load Time (sec)",
    description:
      "The average time (in seconds) pages from the sample set take to load, from initiation of the pageview (e.g., a click on a page link) to load completion in the browser.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:domainLookupTime",
    name: "Domain Lookup Time (ms)",
    description:
      "The total time (in milliseconds) all samples spent in DNS lookup for this page.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgDomainLookupTime",
    name: "Avg. Domain Lookup Time (sec)",
    description:
      "The average time (in seconds) spent in DNS lookup for this page.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:pageDownloadTime",
    name: "Page Download Time (ms)",
    description:
      "The total time (in milliseconds) to download this page among all samples.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgPageDownloadTime",
    name: "Avg. Page Download Time (sec)",
    description: "The average time (in seconds) to download this page.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:redirectionTime",
    name: "Redirection Time (ms)",
    description:
      "The total time (in milliseconds) all samples spent in redirects before fetching this page. If there are no redirects, this is 0.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgRedirectionTime",
    name: "Avg. Redirection Time (sec)",
    description:
      "The average time (in seconds) spent in redirects before fetching this page. If there are no redirects, this is 0.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:serverConnectionTime",
    name: "Server Connection Time (ms)",
    description:
      "Total time (in milliseconds) all samples spent in establishing a TCP connection to this page.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgServerConnectionTime",
    name: "Avg. Server Connection Time (sec)",
    description:
      "The average time (in seconds) spent in establishing a TCP connection to this page.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:serverResponseTime",
    name: "Server Response Time (ms)",
    description:
      "The total time (in milliseconds) the site's server takes to respond to users' requests among all samples; this includes the network time from users' locations to the server.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgServerResponseTime",
    name: "Avg. Server Response Time (sec)",
    description:
      "The average time (in seconds) the site's server takes to respond to users' requests; this includes the network time from users' locations to the server.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:speedMetricsSample",
    name: "Speed Metrics Sample",
    description:
      "The sample set (or count) of pageviews used to calculate the averages of site speed metrics. This metric is used in all site speed average calculations, including avgDomainLookupTime, avgPageDownloadTime, avgRedirectionTime, avgServerConnectionTime, and avgServerResponseTime.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:domInteractiveTime",
    name: "Document Interactive Time (ms)",
    description:
      "The time (in milliseconds), including the network time from users' locations to the site's server, the browser takes to parse the document (DOMInteractive). At this time, users can interact with the Document Object Model even though it is not fully loaded.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgDomInteractiveTime",
    name: "Avg. Document Interactive Time (sec)",
    description:
      "The average time (in seconds), including the network time from users' locations to the site's server, the browser takes to parse the document and execute deferred and parser-inserted scripts.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:domContentLoadedTime",
    name: "Document Content Loaded Time (ms)",
    description:
      "The time (in milliseconds), including the network time from users' locations to the site's server, the browser takes to parse the document and execute deferred and parser-inserted scripts (DOMContentLoaded). When parsing of the document is finished, the Document Object Model (DOM) is ready, but the referenced style sheets, images, and subframes may not be finished loading. This is often the starting point of Javascript framework execution, e.g., JQuery's onready() callback.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:avgDomContentLoadedTime",
    name: "Avg. Document Content Loaded Time (sec)",
    description:
      "The average time (in seconds) the browser takes to parse the document.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:domLatencyMetricsSample",
    name: "DOM Latency Metrics Sample",
    description:
      "Sample set (or count) of pageviews used to calculate the averages for site speed DOM metrics. This metric is used to calculate ga:avgDomContentLoadedTime and ga:avgDomInteractiveTime.",
    section: "Site Speed",
    is_active: true,
  },
  {
    id: "ga:screenviews",
    name: "Screen Views",
    description: "The total number of screenviews.",
    section: "App Tracking",
    is_active: true,
  },
  {
    id: "ga:uniqueScreenviews",
    name: "Unique Screen Views",
    description:
      "The number of unique screen views. Screen views in different sessions are counted as separate screen views.",
    section: "App Tracking",
    is_active: true,
  },
  {
    id: "ga:screenviewsPerSession",
    name: "Screens / Session",
    description: "The average number of screenviews per session.",
    section: "App Tracking",
    is_active: true,
  },
  {
    id: "ga:timeOnScreen",
    name: "Time on Screen",
    description: "The time spent viewing the current screen.",
    section: "App Tracking",
    is_active: true,
  },
  {
    id: "ga:avgScreenviewDuration",
    name: "Avg. Time on Screen",
    description: "Average time (in seconds) users spent on a screen.",
    section: "App Tracking",
    is_active: true,
  },
  {
    id: "ga:totalEvents",
    name: "Total Events",
    description:
      "The total number of events for the profile, across all categories.",
    section: "Event Tracking",
    is_active: true,
  },
  {
    id: "ga:uniqueDimensionCombinations",
    name: "Unique Dimension Combinations",
    description:
      "Unique Dimension Combinations counts the number of unique dimension-value combinations for each dimension in a report. This lets you build combined (concatenated) dimensions post-processing, which allows for more flexible reporting without having to update your tracking implementation or use additional custom-dimension slots. For more information, see https://support.google.com/analytics/answer/7084499.",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:eventValue",
    name: "Event Value",
    description: "Total value of events for the profile.",
    section: "Event Tracking",
    is_active: true,
  },
  {
    id: "ga:avgEventValue",
    name: "Avg. Value",
    description: "The average value of an event.",
    section: "Event Tracking",
    is_active: true,
  },
  {
    id: "ga:sessionsWithEvent",
    name: "Sessions with Event",
    description: "The total number of sessions with events.",
    section: "Event Tracking",
    is_active: true,
  },
  {
    id: "ga:eventsPerSessionWithEvent",
    name: "Events / Session with Event",
    description: "The average number of events per session with event.",
    section: "Event Tracking",
    is_active: true,
  },
  {
    id: "ga:transactions",
    name: "Transactions",
    description: "The total number of transactions.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:transactionsPerSession",
    name: "Ecommerce Conversion Rate",
    description: "The average number of transactions in a session.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:transactionRevenue",
    name: "Revenue",
    description:
      "The total sale revenue (excluding shipping and tax) of the transaction.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:revenuePerTransaction",
    name: "Average Order Value",
    description: "The average revenue of an ecommerce transaction.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:transactionRevenuePerSession",
    name: "Per Session Value",
    description: "Average transaction revenue for a session.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:transactionShipping",
    name: "Shipping",
    description: "The total cost of shipping.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:transactionTax",
    name: "Tax",
    description: "Total tax for the transaction.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:totalValue",
    name: "Total Value",
    description:
      "Total value for the property (including total revenue and total goal value).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:itemQuantity",
    name: "Quantity",
    description:
      "Total number of items purchased. For example, if users purchase 2 frisbees and 5 tennis balls, this will be 7.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:uniquePurchases",
    name: "Unique Purchases",
    description:
      "The number of product sets purchased. For example, if users purchase 2 frisbees and 5 tennis balls from the site, this will be 2.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:revenuePerItem",
    name: "Average Price",
    description: "The average revenue per item.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:itemRevenue",
    name: "Product Revenue",
    description: "The total revenue from purchased product items.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:itemsPerPurchase",
    name: "Average QTY",
    description:
      "The average quantity of this item (or group of items) sold per purchase.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:localTransactionRevenue",
    name: "Local Revenue",
    description: "Transaction revenue in local currency.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:localTransactionShipping",
    name: "Local Shipping",
    description: "Transaction shipping cost in local currency.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:localTransactionTax",
    name: "Local Tax",
    description: "Transaction tax in local currency.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:localItemRevenue",
    name: "Local Product Revenue",
    description: "Product revenue in local currency.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:socialInteractions",
    name: "Social Actions",
    description: "The total number of social interactions.",
    section: "Social Interactions",
    is_active: true,
  },
  {
    id: "ga:uniqueSocialInteractions",
    name: "Unique Social Actions",
    description:
      "The number of sessions during which the specified social action(s) occurred at least once. This is based on the the unique combination of socialInteractionNetwork, socialInteractionAction, and socialInteractionTarget.",
    section: "Social Interactions",
    is_active: true,
  },
  {
    id: "ga:socialInteractionsPerSession",
    name: "Actions Per Social Session",
    description: "The number of social interactions per session.",
    section: "Social Interactions",
    is_active: true,
  },
  {
    id: "ga:userTimingValue",
    name: "User Timing (ms)",
    description: "Total number of milliseconds for user timing.",
    section: "User Timings",
    is_active: true,
  },
  {
    id: "ga:userTimingSample",
    name: "User Timing Sample",
    description:
      "The number of hits sent for a particular userTimingCategory, userTimingLabel, or userTimingVariable.",
    section: "User Timings",
    is_active: true,
  },
  {
    id: "ga:avgUserTimingValue",
    name: "Avg. User Timing (sec)",
    description: "The average elapsed time.",
    section: "User Timings",
    is_active: true,
  },
  {
    id: "ga:exceptions",
    name: "Exceptions",
    description: "The number of exceptions sent to Google Analytics.",
    section: "Exceptions",
    is_active: true,
  },
  {
    id: "ga:exceptionsPerScreenview",
    name: "Exceptions / Screen",
    description:
      "The number of exceptions thrown divided by the number of screenviews.",
    section: "Exceptions",
    is_active: true,
  },
  {
    id: "ga:fatalExceptions",
    name: "Crashes",
    description: "The number of exceptions where isFatal is set to true.",
    section: "Exceptions",
    is_active: true,
  },
  {
    id: "ga:fatalExceptionsPerScreenview",
    name: "Crashes / Screen",
    description:
      "The number of fatal exceptions thrown divided by the number of screenviews.",
    section: "Exceptions",
    is_active: true,
  },
  {
    id: "ga:metricXX",
    name: "Custom Metric XX Value",
    description:
      "The value of the requested custom metric, where XX refers to the number or index of the custom metric. Note that the data type of ga:metricXX can be INTEGER, CURRENCY, or TIME.",
    section: "Custom Variables or Columns",
    is_active: true,
  },
  // { id: 'ga:dcmFloodlightQuantity', name: 'DFA Conversions', description: 'The number of DCM Floodlight conversions (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmFloodlightRevenue', name: 'DFA Revenue', description: 'DCM Floodlight revenue (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  {
    id: "ga:adsenseRevenue",
    name: "AdSense Revenue",
    description: "The total revenue from AdSense ads.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseAdUnitsViewed",
    name: "AdSense Ad Units Viewed",
    description:
      "The number of AdSense ad units viewed. An ad unit is a set of ads displayed as a result of one piece of the AdSense ad code. For details, see https://support.google.com/adsense/answer/32715?hl=en.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseAdsViewed",
    name: "AdSense Impressions",
    description:
      "The number of AdSense ads viewed. Multiple ads can be displayed within an ad Unit.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseAdsClicks",
    name: "AdSense Ads Clicked",
    description: "The number of times AdSense ads on the site were clicked.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsensePageImpressions",
    name: "AdSense Page Impressions",
    description:
      "The number of pageviews during which an AdSense ad was displayed. A page impression can have multiple ad Units.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseCTR",
    name: "AdSense CTR",
    description:
      "The percentage of page impressions resulted in a click on an AdSense ad.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseECPM",
    name: "AdSense eCPM",
    description:
      "The estimated cost per thousand page impressions. It is the AdSense Revenue per 1,000 page impressions.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseExits",
    name: "AdSense Exits",
    description:
      "The number of sessions ended due to a user clicking on an AdSense ad.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseViewableImpressionPercent",
    name: "AdSense Viewable Impression %",
    description: "The percentage of viewable impressions.",
    section: "Adsense",
    is_active: true,
  },
  {
    id: "ga:adsenseCoverage",
    name: "AdSense Coverage",
    description: "The percentage of ad requests that returned at least one ad.",
    section: "Adsense",
    is_active: true,
  },
  // { id: 'ga:adxImpressions', name: 'AdX Impressions', description: 'An Ad Exchange ad impression is reported whenever an individual ad is displayed on the website. For example, if a page with two ad units is viewed once, we\'ll display two impressions.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxCoverage', name: 'AdX Coverage', description: 'Coverage is the percentage of ad requests that returned at least one ad. Generally, coverage can help identify sites where the Ad Exchange account isn\'t able to provide targeted ads. (Ad Impressions / Total Ad Requests) * 100', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxMonetizedPageviews', name: 'AdX Monetized Pageviews', description: 'This measures the total number of pageviews on the property that were shown with an ad from the linked Ad Exchange account. Note that a single page can have multiple ad units.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxImpressionsPerSession', name: 'AdX Impressions / Session', description: 'The ratio of Ad Exchange ad impressions to Analytics sessions (Ad Impressions / Analytics Sessions).', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxViewableImpressionsPercent', name: 'AdX Viewable Impressions %', description: 'The percentage of viewable ad impressions. An impression is considered a viewable impression when it has appeared within users\' browsers and has the opportunity to be seen.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxClicks', name: 'AdX Clicks', description: 'The number of times AdX ads were clicked on the site.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxCTR', name: 'AdX CTR', description: 'The percentage of pageviews that resulted in a click on an Ad Exchange ad.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxRevenue', name: 'AdX Revenue', description: 'The total estimated revenue from Ad Exchange ads.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxRevenuePer1000Sessions', name: 'AdX Revenue / 1000 Sessions', description: 'The total estimated revenue from Ad Exchange ads per 1,000 Analytics sessions. Note that this metric is based on sessions to the site, not on ad impressions.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:adxECPM', name: 'AdX eCPM', description: 'The effective cost per thousand pageviews. It is the Ad Exchange revenue per 1,000 pageviews.', section: 'Ad Exchange', is_active: true },
  // { id: 'ga:dfpImpressions', name: 'DFP Impressions', description: 'A DFP ad impression is reported whenever an individual ad is displayed on the website. For example, if a page with two ad units is viewed once, we\'ll display two impressions (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpCoverage', name: 'DFP Coverage', description: 'Coverage is the percentage of ad requests that returned at least one ad. Generally, coverage can help identify sites where the DFP account isn\'t able to provide targeted ads. (Ad Impressions / Total Ad Requests) * 100 (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpMonetizedPageviews', name: 'DFP Monetized Pageviews', description: 'This measures the total number of pageviews on the property that were shown with an ad from the linked DFP account. Note that a single page can have multiple ad units (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpImpressionsPerSession', name: 'DFP Impressions / Session', description: 'The ratio of DFP ad impressions to Analytics sessions (Ad Impressions / Analytics Sessions) (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpViewableImpressionsPercent', name: 'DFP Viewable Impressions %', description: 'The percentage of viewable ad impressions. An impression is considered a viewable impression when it has appeared within users\' browsers and has the opportunity to be seen (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpClicks', name: 'DFP Clicks', description: 'The number of times DFP ads were clicked on the site (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpCTR', name: 'DFP CTR', description: 'The percentage of pageviews that resulted in a click on an DFP ad (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpRevenue', name: 'DFP Revenue', description: 'DFP revenue is an estimate of the total ad revenue based on served impressions (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpRevenuePer1000Sessions', name: 'DFP Revenue / 1000 Sessions', description: 'The total estimated revenue from DFP ads per 1,000 Analytics sessions. Note that this metric is based on sessions to the site, not on ad impressions (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:dfpECPM', name: 'DFP eCPM', description: 'The effective cost per thousand pageviews. It is the DFP revenue per 1,000 pageviews (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers', is_active: true },
  // { id: 'ga:backfillImpressions', name: 'DFP Backfill Impressions', description: 'Backfill Impressions is the sum of all AdSense or Ad Exchance ad impressions served as backfill through DFP. An ad impression is reported whenever an individual ad is displayed on the website. For example, if a page with two ad units is viewed once, we\'ll display two impressions (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillCoverage', name: 'DFP Backfill Coverage', description: 'Backfill Coverage is the percentage of backfill ad requests that returned at least one ad. Generally, coverage can help identify sites where the publisher account isn\'t able to provide targeted ads. (Ad Impressions / Total Ad Requests) * 100. If both AdSense and Ad Exchange are providing backfill ads, this metric is the weighted average of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillMonetizedPageviews', name: 'DFP Backfill Monetized Pageviews', description: 'This measures the total number of pageviews on the property that were shown with at least one ad from the linked backfill account(s). Note that a single monetized pageview can include multiple ad impressions (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillImpressionsPerSession', name: 'DFP Backfill Impressions / Session', description: 'The ratio of backfill ad impressions to Analytics sessions (Ad Impressions / Analytics Sessions). If both AdSense and Ad Exchange are providing backfill ads, this metric is the sum of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillViewableImpressionsPercent', name: 'DFP Backfill Viewable Impressions %', description: 'The percentage of backfill ad impressions that were viewable. An impression is considered a viewable impression when it has appeared within the users\' browsers and had the opportunity to be seen. If AdSense and Ad Exchange are both providing backfill ads, this metric is the weighted average of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillClicks', name: 'DFP Backfill Clicks', description: 'The number of times backfill ads were clicked on the site. If AdSense and Ad Exchange are both providing backfill ads, this metric is the sum of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillCTR', name: 'DFP Backfill CTR', description: 'The percentage of backfill impressions that resulted in a click on an ad. If AdSense and Ad Exchange are both providing backfill ads, this metric is the weighted average of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillRevenue', name: 'DFP Backfill Revenue', description: 'The total estimated revenue from backfill ads. If AdSense and Ad Exchange are both providing backfill ads, this metric is the sum of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillRevenuePer1000Sessions', name: 'DFP Backfill Revenue / 1000 Sessions', description: 'The total estimated revenue from backfill ads per 1,000 Analytics sessions. Note that this metric is based on sessions to the site and not ad impressions. If both AdSense and Ad Exchange are providing backfill ads, this metric is the sum of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  // { id: 'ga:backfillECPM', name: 'DFP Backfill eCPM', description: 'The effective cost per thousand pageviews. It is the DFP Backfill Revenue per 1,000 pageviews. If both AdSense and Ad Exchange are providing backfill ads, this metric is the sum of the two backfill accounts (DFP linking enabled and Hide DFP Revenue not enabled).', section: 'DoubleClick for Publishers Backfill', is_active: true },
  {
    id: "ga:buyToDetailRate",
    name: "Buy-to-Detail Rate",
    description:
      "Unique purchases divided by views of product detail pages (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:calcMetric_<NAME>",
    name: "Calculated Metric",
    description:
      "The value of the requested calculated metric, where <NAME> refers to the user-defined name of the calculated metric. Note that the data type of ga:calcMetric_<NAME> can be FLOAT, INTEGER, CURRENCY, TIME, or PERCENT. For details, see https://support.google.com/analytics/answer/6121409.",
    section: "Custom Variables or Columns",
    is_active: true,
  },
  {
    id: "ga:cartToDetailRate",
    name: "Cart-to-Detail Rate",
    description:
      "Product adds divided by views of product details (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:cohortActiveUsers",
    name: "Users",
    description:
      "This metric is relevant in the context of ga:cohortNthDay/ga:cohortNthWeek/ga:cohortNthMonth. It indicates the number of users in the cohort who are active in the time window corresponding to the cohort nth day/week/month. For example, for ga:cohortNthWeek = 1, number of users (in the cohort) who are active in week 1. If a request doesn't have any of ga:cohortNthDay/ga:cohortNthWeek/ga:cohortNthMonth, this metric will have the same value as ga:cohortTotalUsers.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortAppviewsPerUser",
    name: "Appviews per User",
    description: "App views per user for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortAppviewsPerUserWithLifetimeCriteria",
    name: "Appviews Per User (LTV)",
    description:
      "App views per user for the acquisition dimension for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortGoalCompletionsPerUser",
    name: "Goal Completions per User",
    description:
      "Goal completions per user for the acquisition dimension for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortGoalCompletionsPerUserWithLifetimeCriteria",
    name: "Goal Completions Per User (LTV)",
    description: "Goal completions per user for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortPageviewsPerUser",
    name: "Pageviews per User",
    description: "Pageviews per user for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortPageviewsPerUserWithLifetimeCriteria",
    name: "Pageviews Per User (LTV)",
    description:
      "Pageviews per user for the acquisition dimension for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortRetentionRate",
    name: "User Retention",
    description: "Cohort retention rate.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortRevenuePerUser",
    name: "Revenue per User",
    description: "Revenue per user for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortRevenuePerUserWithLifetimeCriteria",
    name: "Revenue Per User (LTV)",
    description: "Revenue per user for the acquisition dimension for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortSessionDurationPerUser",
    name: "Session Duration per User",
    description: "Session duration per user for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortSessionDurationPerUserWithLifetimeCriteria",
    name: "Session Duration Per User (LTV)",
    description:
      "Session duration per user for the acquisition dimension for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortSessionsPerUser",
    name: "Sessions per User",
    description: "Sessions per user for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortSessionsPerUserWithLifetimeCriteria",
    name: "Sessions Per User (LTV)",
    description:
      "Sessions per user for the acquisition dimension for a cohort.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortTotalUsers",
    name: "Total Users",
    description:
      "Number of users belonging to the cohort, also known as cohort size.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:cohortTotalUsersWithLifetimeCriteria",
    name: "Users",
    description:
      "This is relevant in the context of a request which has the dimensions ga:acquisitionTrafficChannel/ga:acquisitionSource/ga:acquisitionMedium/ga:acquisitionCampaign. It represents the number of users in the cohorts who are acquired through the current channel/source/medium/campaign. For example, for ga:acquisitionTrafficChannel=Direct, it represents the number users in the cohort, who were acquired directly. If none of these mentioned dimensions are present, then its value is equal to ga:cohortTotalUsers.",
    section: "Lifetime Value and Cohorts",
    is_active: true,
  },
  {
    id: "ga:correlationScore",
    name: "Correlation Score",
    description: "Correlation Score for related products.",
    section: "Related Products",
    is_active: true,
  },
  // { id: 'ga:dbmCPA', name: 'DBM eCPA', description: 'DBM Revenue eCPA (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmCPC', name: 'DBM eCPC', description: 'DBM Revenue eCPC (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmCPM', name: 'DBM eCPM', description: 'DBM Revenue eCPM (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmCTR', name: 'DBM CTR', description: 'DBM CTR (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmClicks', name: 'DBM Clicks', description: 'DBM Total Clicks (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmConversions', name: 'DBM Conversions', description: 'DBM Total Conversions (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmCost', name: 'DBM Cost', description: 'DBM Cost (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmImpressions', name: 'DBM Impressions', description: 'DBM Total Impressions (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dbmROAS', name: 'DBM ROAS', description: 'DBM ROAS (Analytics 360 only, requires integration with DBM).', section: 'DoubleClick Bid Manager', is_active: true },
  // { id: 'ga:dcmCPC', name: 'DFA CPC', description: 'DCM Cost Per Click (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmCTR', name: 'DFA CTR', description: 'DCM Click Through Rate (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmClicks', name: 'DFA Clicks', description: 'DCM Total Clicks (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmCost', name: 'DFA Cost', description: 'DCM Total Cost (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmImpressions', name: 'DFA Impressions', description: 'DCM Total Impressions (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmROAS', name: 'DFA ROAS', description: 'DCM Return On Ad Spend (ROAS) (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dcmRPC', name: 'DFA RPC', description: 'DCM Revenue Per Click (Analytics 360 only).', section: 'DoubleClick Campaign Manager', is_active: true },
  // { id: 'ga:dsCPC', name: 'DS CPC', description: 'DS Cost to advertiser per click (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsCTR', name: 'DS CTR', description: 'DS Click Through Rate (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsClicks', name: 'DS Clicks', description: 'DS Clicks (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsCost', name: 'DS Cost', description: 'DS Cost (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsImpressions', name: 'DS Impressions', description: 'DS Impressions (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsProfit', name: 'DS Profit', description: 'DS Profie (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsReturnOnAdSpend', name: 'DS ROAS', description: 'DS Return On Ad Spend (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  // { id: 'ga:dsRevenuePerClick', name: 'DS RPC', description: 'DS Revenue Per Click (Analytics 360 only, requires integration with DS).', section: 'DoubleClick Search', is_active: true },
  {
    id: "ga:hits",
    name: "Hits",
    description:
      "Total number of hits for the view (profile). This metric sums all hit types, including pageview, custom event, ecommerce, and other types. Because this metric is based on the view (profile), not on the property, it is not the same as the property's hit volume.",
    section: "Session",
    is_active: true,
  },
  {
    id: "ga:internalPromotionCTR",
    name: "Internal Promotion CTR",
    description:
      "The rate at which users clicked through to view the internal promotion (ga:internalPromotionClicks / ga:internalPromotionViews) - (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:internalPromotionClicks",
    name: "Internal Promotion Clicks",
    description:
      "The number of clicks on an internal promotion (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:internalPromotionViews",
    name: "Internal Promotion Views",
    description:
      "The number of views of an internal promotion (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:localProductRefundAmount",
    name: "Local Product Refund Amount",
    description:
      "Refund amount in local currency for a given product (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:localRefundAmount",
    name: "Local Refund Amount",
    description:
      "Total refund amount in local currency for the transaction (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productAddsToCart",
    name: "Product Adds To Cart",
    description:
      "Number of times the product was added to the shopping cart (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productCheckouts",
    name: "Product Checkouts",
    description:
      "Number of times the product was included in the check-out process (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productDetailViews",
    name: "Product Detail Views",
    description:
      "Number of times users viewed the product-detail page (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productListCTR",
    name: "Product List CTR",
    description:
      "The rate at which users clicked through on the product in a product list (ga:productListClicks / ga:productListViews) - (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productListClicks",
    name: "Product List Clicks",
    description:
      "Number of times users clicked the product when it appeared in the product list (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productListViews",
    name: "Product List Views",
    description:
      "Number of times the product appeared in a product list (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productRefundAmount",
    name: "Product Refund Amount",
    description:
      "Total refund amount associated with the product (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productRefunds",
    name: "Product Refunds",
    description:
      "Number of times a refund was issued for the product (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productRemovesFromCart",
    name: "Product Removes From Cart",
    description:
      "Number of times the product was removed from the shopping cart (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:productRevenuePerPurchase",
    name: "Product Revenue per Purchase",
    description:
      "Average product revenue per purchase (commonly used with Product Coupon Code) (ga:itemRevenue / ga:uniquePurchases) - (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:quantityAddedToCart",
    name: "Quantity Added To Cart",
    description:
      "Number of product units added to the shopping cart (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:quantityCheckedOut",
    name: "Quantity Checked Out",
    description:
      "Number of product units included in check out (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:quantityRefunded",
    name: "Quantity Refunded",
    description: "Number of product units refunded (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:quantityRemovedFromCart",
    name: "Quantity Removed From Cart",
    description:
      "Number of product units removed from a shopping cart (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:queryProductQuantity",
    name: "Queried Product Quantity",
    description: "Quantity of the product being queried.",
    section: "Related Products",
    is_active: true,
  },
  {
    id: "ga:refundAmount",
    name: "Refund Amount",
    description:
      "Currency amount refunded for a transaction (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:relatedProductQuantity",
    name: "Related Product Quantity",
    description: "Quantity of the related product.",
    section: "Related Products",
    is_active: true,
  },
  {
    id: "ga:revenuePerUser",
    name: "Revenue per User",
    description:
      "The total sale revenue (excluding shipping and tax) of the transaction divided by the total number of users.",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:sessionsPerUser",
    name: "Number of Sessions per User",
    description:
      "The total number of sessions divided by the total number of users.",
    section: "User",
    is_active: true,
  },
  {
    id: "ga:totalRefunds",
    name: "Refunds",
    description:
      "Number of refunds that have been issued (Enhanced Ecommerce).",
    section: "Ecommerce",
    is_active: true,
  },
  {
    id: "ga:transactionsPerUser",
    name: "Transactions per User",
    description:
      "Total number of transactions divided by total number of users.",
    section: "Ecommerce",
    is_active: true,
  },
];

export const segments = [
  { id: "gaid::-1", name: "All Users", description: "", is_active: true },
  {
    id: "gaid::-2",
    name: "New Users",
    description: "sessions::condition::ga:userType==New Visitor",
    is_active: true,
  },
  {
    id: "gaid::-3",
    name: "Returning Users",
    description: "sessions::condition::ga:userType==Returning Visitor",
    is_active: true,
  },
  {
    id: "gaid::-4",
    name: "Paid Traffic",
    description: "sessions::condition::ga:medium=~^(cpc|ppc|cpa|cpm|cpv|cpp)$",
    is_active: true,
  },
  {
    id: "gaid::-5",
    name: "Organic Traffic",
    description: "sessions::condition::ga:medium==organic",
    is_active: true,
  },
  {
    id: "gaid::-6",
    name: "Search Traffic",
    description:
      "sessions::condition::ga:medium=~^(cpc|ppc|cpa|cpm|cpv|cpp|organic)$",
    is_active: true,
  },
  {
    id: "gaid::-7",
    name: "Direct Traffic",
    description: "sessions::condition::ga:medium==(none)",
    is_active: true,
  },
  {
    id: "gaid::-8",
    name: "Referral Traffic",
    description: "sessions::condition::ga:medium==referral",
    is_active: true,
  },
  {
    id: "gaid::-9",
    name: "Sessions with Conversions",
    description: "sessions::condition::ga:goalCompletionsAll>0",
    is_active: true,
  },
  {
    id: "gaid::-10",
    name: "Sessions with Transactions",
    description: "sessions::condition::ga:transactions>0",
    is_active: true,
  },
  {
    id: "gaid::-11",
    name: "Mobile and Tablet Traffic",
    description:
      "sessions::condition::ga:deviceCategory==mobile,ga:deviceCategory==tablet",
    is_active: true,
  },
  {
    id: "gaid::-12",
    name: "Non-bounce Sessions",
    description: "sessions::condition::ga:bounces==0",
    is_active: true,
  },
  {
    id: "gaid::-13",
    name: "Tablet Traffic",
    description: "sessions::condition::ga:deviceCategory==tablet",
    is_active: true,
  },
  {
    id: "gaid::-14",
    name: "Mobile Traffic",
    description: "sessions::condition::ga:deviceCategory==mobile",
    is_active: true,
  },
  {
    id: "gaid::-15",
    name: "Tablet and Desktop Traffic",
    description:
      "sessions::condition::ga:deviceCategory==tablet,ga:deviceCategory==desktop",
    is_active: true,
  },
  {
    id: "gaid::-16",
    name: "Android Traffic",
    description: "sessions::condition::ga:operatingSystem==Android",
    is_active: true,
  },
  {
    id: "gaid::-17",
    name: "iOS Traffic",
    description:
      "sessions::condition::ga:operatingSystem=~^(iOS|iPad|iPhone|iPod)$",
    is_active: true,
  },
  {
    id: "gaid::-18",
    name: "Other Traffic (Neither iOS nor Android)",
    description:
      "sessions::condition::ga:operatingSystem!~^(Android|iOS|iPad|iPhone|iPod)$",
    is_active: true,
  },
  {
    id: "gaid::-19",
    name: "Bounced Sessions",
    description: "sessions::condition::ga:bounces>0",
    is_active: true,
  },
  {
    id: "gaid::-100",
    name: "Single Session Users",
    description: "users::condition::ga:sessions==1",
    is_active: true,
  },
  {
    id: "gaid::-101",
    name: "Multi-session Users",
    description: "users::condition::ga:sessions>1",
    is_active: true,
  },
  {
    id: "gaid::-102",
    name: "Converters",
    description: "users::condition::ga:goalCompletionsAll>0,ga:transactions>0",
    is_active: true,
  },
  {
    id: "gaid::-103",
    name: "Non-Converters",
    description:
      "users::condition::ga:goalCompletionsAll==0;ga:transactions==0",
    is_active: true,
  },
  {
    id: "gaid::-104",
    name: "Made a Purchase",
    description: "users::condition::ga:transactions>0",
    is_active: true,
  },
  {
    id: "gaid::-105",
    name: "Performed Site Search",
    description: "users::sequence::ga:searchKeyword!~^$|^\\(not set\\)$",
    is_active: true,
  },
];

fields["ga:date"].grouping_options = [
  "hour",
  "day",
  "week",
  "month",
  "year",
  "hour-of-day",
  "day-of-week",
  "week-of-year",
  "month-of-year",
];
