/* eslint-disable no-color-literals */

import React, { Component } from "react";

import { connect } from "react-redux";
import { PLUGIN_SELECTORS } from "metabase/plugins";

const mapStateToProps = (state, props) => ({
  showAuthScene: PLUGIN_SELECTORS.getShowAuthScene(state, props),
});

class AuthScene extends Component {
  render() {
    if (!this.props.showAuthScene) {
      return null;
    }

    return (
      <section className="z1 brand-scene absolute bottom left right hide sm-show">
        <div className="brand-boat-container">
          <svg
            className="brand-boat"
            width="27px"
            height="28px"
            viewBox="0 0 27 28"
          >
            <g
              stroke="none"
              strokeWidth="1"
              fill="none"
              fillRule="evenodd"
              ref="HACK_fill_rule_1"
            >
              <g transform="translate(-52.000000, -49.000000)" fill="#fff">
                <path
                  d="M56.9966734,62.0821591 C56.9548869,62.5960122 56.5246217,63 56,63 C55.4477153,63 55,62.5522847 55,62 C55,61.4477153 55.4477153,61 56,61 C56.1542427,61 56.3003292,61.0349209 56.4307846,61.0972878 C56.4365546,60.9708421 56.4672874,60.8469847 56.5249064,60.738086 L60.591292,53.0527085 C60.6128147,53.0120312 60.6340855,52.9741034 60.6550548,52.9389125 C60.2727349,52.7984089 60,52.4310548 60,52 C60,51.4477153 60.4477153,51 61,51 C61.5522847,51 62,51.4477153 62,52 C62,52.4778316 61.6648606,52.8773872 61.2168176,52.9764309 C61.2239494,53.0443316 61.2276783,53.1212219 61.2276783,53.2070193 L61.2276783,64.6460667 C61.2276783,64.7905295 61.2109404,64.9142428 61.1799392,65.0161455 C61.6463447,65.1008929 62,65.5091461 62,66 C62,66.5522847 61.5522847,67 61,67 C60.4477153,67 60,66.5522847 60,66 C60,65.6775356 60.1526298,65.3907197 60.3895873,65.2078547 C60.3353792,65.1698515 60.2797019,65.1246206 60.2229246,65.0720038 L56.9966734,62.0821591 Z M66.1768361,51.0536808 L76.3863147,62.9621534 C76.6248381,62.7575589 76.9348843,62.6339439 77.2738087,62.6339439 C78.0269541,62.6339439 78.6374991,63.2443563 78.6374991,63.9973383 C78.6374991,64.7503202 78.0269541,65.3607327 77.2738087,65.3607327 C76.7179077,65.3607327 76.2396954,65.0281798 76.0273418,64.5512033 L76.0273418,64.5512033 L66.2470617,68.8970508 L66.2470617,68.8970508 C66.3224088,69.0662913 66.3642852,69.2537142 66.3642852,69.4509158 C66.3642852,70.2038977 65.7537402,70.8143102 65.0005948,70.8143102 C64.2474494,70.8143102 63.6369043,70.2038977 63.6369043,69.4509158 C63.6369043,68.6979339 64.2474494,68.0875214 65.0005948,68.0875214 L65.0005948,51.7267888 C64.2474494,51.7267888 63.6369043,51.1163763 63.6369043,50.3633944 C63.6369043,49.6104125 64.2474494,49 65.0005948,49 C65.7537402,49 66.3642852,49.6104125 66.3642852,50.3633944 C66.3642852,50.6152816 66.2959632,50.8512148 66.1768361,51.0536808 L66.1768361,51.0536808 Z M74.9589487,72 C76.0592735,72 76.2934239,72.6072543 75.4783436,73.3596586 L73.4702868,75.2133052 C72.656816,75.9642239 71.1011127,76.5729638 69.999426,76.5729638 L57.9641665,76.5729638 C56.8607339,76.5729638 55.3083859,75.9657095 54.4933056,75.2133052 L52.4852488,73.3596586 C51.6717779,72.6087399 51.9052063,72 53.0046438,72 L74.9589487,72 Z"
                  id="boat"
                />
              </g>
            </g>
          </svg>
        </div>
        <div className="brand-illustration">
          <div className="brand-mountain-1">
            <svg
              width="514px"
              height="175px"
              viewBox="0 0 514 175"
              version="1.1"
            >
              <path
                fill="#fff"
                d="M41.5,45 L78,33 L78,74.5 L2.5,92 L41.5,45 Z"
                id="Path"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M77.5,32.5 L143,45.5 L76.5,75.5 L77.5,32.5 Z"
                id="Path-Copy-8"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M1.5,91 L78,73.5 L87,119.5 L41.5,149 L1.5,91 Z"
                id="Path-Copy"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M77.5000001,74.5 L143,44 L174,46 L86.0000001,119.5 L77.5000001,74.5 Z"
                id="Path-Copy-7"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M142.5,45 L205,25.5 L229,39.5 L173.5,47.5 L142.5,45 Z"
                id="Path-Copy-9"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M158.499999,99 L225.499999,80.5 L270.999999,87.5 L226.999999,125 L158.499999,99 Z"
                id="Path-Copy-3"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M156.499999,101.5 L172.999999,47 L226.499999,39 L226.499999,81 L156.499999,101.5 Z"
                id="Path-Copy-11"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M243.000001,88.5 L225.5,43.5 L288,39 L288,81.5 L243.000001,88.5 Z"
                id="Path-Copy-12"
                stroke="#B6CCE5"
                transform="translate(256.750000, 63.750000) scale(-1, 1) translate(-256.750000, -63.750000) "
              />
              <path
                fill="#fff"
                d="M286.5,44.5 L342.5,64 L319.5,110.5 L270,86.5 L286.5,44.5 Z"
                id="Path-Copy-4"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M341.5,64 L390.5,111 L396.5,155 L317,109 L341.5,64 Z"
                id="Path-Copy-10"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M389,111 L505,149 L396,154 L389,111 Z"
                id="Path-Copy-13"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M321,110 L397,154 L282,149 L321,110 Z"
                id="Path-Copy-14"
                stroke="#4A90E2"
              />
              <path
                fill="#fff"
                d="M247.5,20.5 L287,44.5 L226.5,40 L247.5,20.5 Z"
                id="Path-Copy-5"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M221.999999,13 L248.499999,20.5 L227.499999,40 L203.999999,26 L221.999999,13 Z"
                id="Path-Copy-6"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M228.499999,126.000001 L284.000003,148.499999 L224.500001,171.000001 L158.500001,148.499999 L228.499999,126.000001 Z"
                id="fg-geometry"
                stroke="#4A90E2"
              />
              <polygon
                fill="#fff"
                id="Path"
                stroke="#4A90E2"
                points="158.5 99 159.5 149 42 149 "
              />
              <path
                fill="#fff"
                d="M271.000001,86.0000002 L321.5,110.5 L283,149.5 L225,125.5 L271.000001,86.0000002 Z"
                id="Path-Copy-3"
                stroke="#4A90E2"
              />
              <path
                fill="#fff"
                d="M42.2061,154.838108 C45.4069681,154.838108 48.0017844,152.243855 48.0017844,149.043682 C48.0017844,145.843509 45.4069681,143.249256 42.2061,143.249256 C39.0052319,143.249256 36.4104157,145.843509 36.4104157,149.043682 C36.4104157,152.243855 39.0052319,154.838108 42.2061,154.838108 Z M159.483477,154.838108 C162.684345,154.838108 165.279162,152.243855 165.279162,149.043682 C165.279162,145.843509 162.684345,143.249256 159.483477,143.249256 C156.282609,143.249256 153.687793,145.843509 153.687793,149.043682 C153.687793,152.243855 156.282609,154.838108 159.483477,154.838108 Z M282.215617,154.838108 C285.416485,154.838108 288.011301,152.243855 288.011301,149.043682 C288.011301,145.843509 285.416485,143.249256 282.215617,143.249256 C279.014748,143.249256 276.419932,145.843509 276.419932,149.043682 C276.419932,152.243855 279.014748,154.838108 282.215617,154.838108 Z M505.860848,154.156411 C509.061716,154.156411 511.656532,151.562158 511.656532,148.361985 C511.656532,145.161811 509.061716,142.567558 505.860848,142.567558 C502.65998,142.567558 500.065164,145.161811 500.065164,148.361985 C500.065164,151.562158 502.65998,154.156411 505.860848,154.156411 Z M396.083768,159.950837 C399.284636,159.950837 401.879452,157.356584 401.879452,154.156411 C401.879452,150.956238 399.284636,148.361985 396.083768,148.361985 C392.8829,148.361985 390.288084,150.956238 390.288084,154.156411 C390.288084,157.356584 392.8829,159.950837 396.083768,159.950837 Z M319.717104,115.981368 C322.917972,115.981368 325.512788,113.387115 325.512788,110.186942 C325.512788,106.986769 322.917972,104.392516 319.717104,104.392516 C316.516235,104.392516 313.921419,106.986769 313.921419,110.186942 C313.921419,113.387115 316.516235,115.981368 319.717104,115.981368 Z M270.624248,92.8036633 C273.825116,92.8036633 276.419932,90.2094103 276.419932,87.0092371 C276.419932,83.8090639 273.825116,81.214811 270.624248,81.214811 C267.42338,81.214811 264.828563,83.8090639 264.828563,87.0092371 C264.828563,90.2094103 267.42338,92.8036633 270.624248,92.8036633 Z M229.03169,131.660403 C232.232558,131.660403 234.827374,129.06615 234.827374,125.865977 C234.827374,122.665804 232.232558,120.071551 229.03169,120.071551 C225.830822,120.071551 223.236005,122.665804 223.236005,125.865977 C223.236005,129.06615 225.830822,131.660403 229.03169,131.660403 Z M158.119787,104.392516 C161.320655,104.392516 163.915471,101.798263 163.915471,98.5980894 C163.915471,95.3979162 161.320655,92.8036633 158.119787,92.8036633 C154.918919,92.8036633 152.324103,95.3979162 152.324103,98.5980894 C152.324103,101.798263 154.918919,104.392516 158.119787,104.392516 Z M224.940618,173.925629 C228.141486,173.925629 230.736303,171.331376 230.736303,168.131203 C230.736303,164.93103 228.141486,162.336777 224.940618,162.336777 C221.73975,162.336777 219.144934,164.93103 219.144934,168.131203 C219.144934,171.331376 221.73975,173.925629 224.940618,173.925629 Z"
                id="fg-points"
                stroke="#4A90E2"
              />
              <path
                fill="#fff"
                d="M78.0029739,76.4429306 C79.5092648,76.4429306 80.7303548,75.2221057 80.7303548,73.7161419 C80.7303548,72.210178 79.5092648,70.9893531 78.0029739,70.9893531 C76.4966831,70.9893531 75.275593,72.210178 75.275593,73.7161419 C75.275593,75.2221057 76.4966831,76.4429306 78.0029739,76.4429306 Z M3,94.4779116 C4.50629086,94.4779116 5.72738087,93.2570867 5.72738087,91.7511228 C5.72738087,90.245159 4.50629086,89.024334 3,89.024334 C1.49370914,89.024334 0.27261913,90.245159 0.27261913,91.7511228 C0.27261913,93.2570867 1.49370914,94.4779116 3,94.4779116 Z M42.5470226,48.167594 C44.0533135,48.167594 45.2744035,46.9467691 45.2744035,45.4408052 C45.2744035,43.9348413 44.0533135,42.7140164 42.5470226,42.7140164 C41.0407318,42.7140164 39.8196417,43.9348413 39.8196417,45.4408052 C39.8196417,46.9467691 41.0407318,48.167594 42.5470226,48.167594 Z M78.0029739,35.541099 C79.5092648,35.541099 80.7303548,34.3202741 80.7303548,32.8143102 C80.7303548,31.3083464 79.5092648,30.0875214 78.0029739,30.0875214 C76.4966831,30.0875214 75.275593,31.3083464 75.275593,32.8143102 C75.275593,34.3202741 76.4966831,35.541099 78.0029739,35.541099 Z M142.77827,47.1299513 C144.28456,47.1299513 145.50565,45.9091264 145.50565,44.4031625 C145.50565,42.8971987 144.28456,41.6763737 142.77827,41.6763737 C141.271979,41.6763737 140.050889,42.8971987 140.050889,44.4031625 C140.050889,45.9091264 141.271979,47.1299513 142.77827,47.1299513 Z M86.8669617,122.116643 C88.3732526,122.116643 89.5943426,120.895818 89.5943426,119.389854 C89.5943426,117.88389 88.3732526,116.663065 86.8669617,116.663065 C85.3606709,116.663065 84.1395809,117.88389 84.1395809,119.389854 C84.1395809,120.895818 85.3606709,122.116643 86.8669617,122.116643 Z M246.418743,23.2705495 C247.925033,23.2705495 249.146123,22.0497246 249.146123,20.5437607 C249.146123,19.0377969 247.925033,17.8169719 246.418743,17.8169719 C244.912452,17.8169719 243.691362,19.0377969 243.691362,20.5437607 C243.691362,22.0497246 244.912452,23.2705495 246.418743,23.2705495 Z M173.461304,49.8567401 C174.967595,49.8567401 176.188685,48.6359151 176.188685,47.1299513 C176.188685,45.6239874 174.967595,44.4031625 173.461304,44.4031625 C171.955013,44.4031625 170.733923,45.6239874 170.733923,47.1299513 C170.733923,48.6359151 171.955013,49.8567401 173.461304,49.8567401 Z M204.144339,28.0424299 C205.65063,28.0424299 206.87172,26.8216049 206.87172,25.3156411 C206.87172,23.8096772 205.65063,22.5888523 204.144339,22.5888523 C202.638048,22.5888523 201.416958,23.8096772 201.416958,25.3156411 C201.416958,26.8216049 202.638048,28.0424299 204.144339,28.0424299 Z M225.963386,83.2599026 C227.469677,83.2599026 228.690767,82.0390776 228.690767,80.5331138 C228.690767,79.0271499 227.469677,77.806325 225.963386,77.806325 C224.457095,77.806325 223.236005,79.0271499 223.236005,80.5331138 C223.236005,82.0390776 224.457095,83.2599026 225.963386,83.2599026 Z M225.963386,41.6763737 C227.469677,41.6763737 228.690767,40.4555488 228.690767,38.949585 C228.690767,37.4436211 227.469677,36.2227962 225.963386,36.2227962 C224.457095,36.2227962 223.236005,37.4436211 223.236005,38.949585 C223.236005,40.4555488 224.457095,41.6763737 225.963386,41.6763737 Z M390.288084,113.254579 C391.794374,113.254579 393.015464,112.033754 393.015464,110.52779 C393.015464,109.021826 391.794374,107.801002 390.288084,107.801002 C388.781793,107.801002 387.560703,109.021826 387.560703,110.52779 C387.560703,112.033754 388.781793,113.254579 390.288084,113.254579 Z M342.558918,66.8991699 C344.065209,66.8991699 345.286299,65.678345 345.286299,64.1723811 C345.286299,62.6664173 344.065209,61.4455924 342.558918,61.4455924 C341.052627,61.4455924 339.831537,62.6664173 339.831537,64.1723811 C339.831537,65.678345 341.052627,66.8991699 342.558918,66.8991699 Z M286.64761,47.1299513 C288.153901,47.1299513 289.374991,45.9091264 289.374991,44.4031625 C289.374991,42.8971987 288.153901,41.6763737 286.64761,41.6763737 C285.14132,41.6763737 283.92023,42.8971987 283.92023,44.4031625 C283.92023,45.9091264 285.14132,47.1299513 286.64761,47.1299513 Z M221.872315,16.4535776 C223.378606,16.4535776 224.599696,15.2327526 224.599696,13.7267888 C224.599696,12.2208249 223.378606,11 221.872315,11 C220.366024,11 219.144934,12.2208249 219.144934,13.7267888 C219.144934,15.2327526 220.366024,16.4535776 221.872315,16.4535776 Z"
                id="bg-points"
                stroke="#B6CCE6"
              />
            </svg>
          </div>

          <div className="brand-bridge">
            <svg
              width="683px"
              height="154px"
              viewBox="0 0 683 154"
              version="1.1"
            >
              <g
                id="Page-1"
                stroke="none"
                strokeWidth="1"
                fill="none"
                fillRule="evenodd"
                ref="HACK_fill_rule_2"
              >
                <g id="Artboard-1">
                  <path
                    d="M193,69.49194 L193,48.696628 L193,48.696628 C193.437006,48.5974065 193.825695,48.3709078 194.125079,48.0581427 L197.242752,49.9287465 C197.479542,50.0708205 197.786672,49.994038 197.928746,49.7572479 C198.070821,49.5204577 197.994038,49.2133276 197.757248,49.0712535 L194.639252,47.2004558 C194.711048,46.9803849 194.749866,46.7453991 194.749866,46.5013419 C194.749866,45.4300479 194.00192,44.5335399 193,44.3060559 L193,23.4611785 L193,23.4611785 C193.70858,23.3422265 194.332923,22.9747274 194.780416,22.4513446 L197.242752,23.9287465 C197.479542,24.0708205 197.786672,23.994038 197.928746,23.7572479 C198.070821,23.5204577 197.994038,23.2133276 197.757248,23.0712535 L195.294823,21.5937988 C195.427115,21.2552485 195.499732,20.88678 195.499732,20.5013419 C195.499732,18.8437465 194.156706,17.5 192.5,17.5 C190.843294,17.5 189.500268,18.8437465 189.500268,20.5013419 C189.500268,21.1091075 189.680819,21.6746805 189.991183,22.1472957 L165.767183,44.64101 L165.767183,44.64101 C165.406294,44.3944476 164.969976,44.2502684 164.5,44.2502684 C163.257433,44.2502684 162.250134,45.2581083 162.250134,46.5013419 C162.250134,46.9292933 162.369489,47.3293527 162.576711,47.6700143 L138.72545,69.6131742 C138.372873,69.383631 137.952003,69.2502684 137.5,69.2502684 C136.257433,69.2502684 135.250134,70.2581083 135.250134,71.5013419 C135.250134,71.5912406 135.255401,71.6799086 135.265643,71.7670536 L111.39825,80.2911227 C110.99879,79.6645016 110.2979,79.2489265 109.5,79.2489265 C108.429185,79.2489265 107.533094,79.9974077 107.305831,81 L89.6941692,81 C89.4669062,79.9974077 88.5708148,79.2489265 87.5,79.2489265 C86.4291852,79.2489265 85.5330938,79.9974077 85.3058308,81 L60.6941692,81 L60.6941692,81 C60.4669062,79.9974077 59.5708148,79.2489265 58.5,79.2489265 C57.4291852,79.2489265 56.5330938,79.9974077 56.3058308,81 L30.6941692,81 C30.4669062,79.9974077 29.5708148,79.2489265 28.5,79.2489265 C27.4291852,79.2489265 26.5330938,79.9974077 26.3058308,81 L-9,81 L-9,82 L26.3058308,82 C26.5330938,83.0025923 27.4291852,83.7510735 28.5,83.7510735 C29.5708148,83.7510735 30.4669062,83.0025923 30.6941692,82 L30.6941692,82 L56.3058308,82 C56.5330938,83.0025923 57.4291852,83.7510735 58.5,83.7510735 C59.5708148,83.7510735 60.4669062,83.0025923 60.6941692,82 L85.3058308,82 C85.5330938,83.0025923 86.4291852,83.7510735 87.5,83.7510735 C88.5708148,83.7510735 89.4669062,83.0025923 89.6941692,82 L89.6941692,82 L107.305831,82 C107.496622,82.8416934 108.158796,83.5042922 109,83.6952861 L109,83.6952861 L109,91.3060559 C108.159243,91.4969482 107.497326,92.1589443 107.306135,93 L89.6941692,93 L89.6941692,93 C89.4669062,91.9974077 88.5708148,91.2489265 87.5,91.2489265 C86.4291852,91.2489265 85.5330938,91.9974077 85.3058308,93 L60.6941692,93 C60.4669062,91.9974077 59.5708148,91.2489265 58.5,91.2489265 C57.4291852,91.2489265 56.5330938,91.9974077 56.3058308,93 L30.6941692,93 C30.4669062,91.9974077 29.5708148,91.2489265 28.5,91.2489265 C27.4291852,91.2489265 26.5330938,91.9974077 26.3058308,93 L-9,93 L-9,94 L26.3058308,94 C26.5330938,95.0025923 27.4291852,95.7510735 28.5,95.7510735 C29.5708148,95.7510735 30.4669062,95.0025923 30.6941692,94 L56.3058308,94 C56.5330938,95.0025923 57.4291852,95.7510735 58.5,95.7510735 C59.5708148,95.7510735 60.4669062,95.0025923 60.6941692,94 L60.6941692,94 L85.3058308,94 C85.5330938,95.0025923 86.4291852,95.7510735 87.5,95.7510735 C88.5708148,95.7510735 89.4669062,95.0025923 89.6941692,94 L107.305527,94 C107.495918,94.842331 108.158349,95.5055326 109,95.696628 L109,144 L110,144 L110,95.696628 C110.841651,95.5055326 111.504082,94.842331 111.694473,94 L135.305527,94 C135.532294,95.0032662 136.428708,95.7524154 137.5,95.7524154 C138.571292,95.7524154 139.467706,95.0032662 139.694473,94 L162.305527,94 C162.532294,95.0032662 163.428708,95.7524154 164.5,95.7524154 C165.571292,95.7524154 166.467706,95.0032662 166.694473,94 L190.305527,94 C190.495918,94.842331 191.158349,95.5055326 192,95.696628 L192,143 L193,143 L193,95.696628 C193.841651,95.5055326 194.504082,94.842331 194.694473,94 L200,94 L200,93 L194.693865,93 C194.502674,92.1589443 193.840757,91.4969482 193,91.3060559 L193,91.3060559 L193,71.50806 C192.84938,71.5829117 192.679605,71.625 192.5,71.625 C192.320395,71.625 192.15062,71.5829117 192,71.50806 L192,91.3060559 C191.159243,91.4969482 190.497326,92.1589443 190.306135,93 L190.306135,93 L166.693865,93 L166.693865,93 C166.502674,92.1589443 165.840757,91.4969482 165,91.3060559 L165,48.696628 C166.00192,48.4691439 166.749866,47.5726359 166.749866,46.5013419 C166.749866,46.0904765 166.639851,45.7053203 166.447687,45.3737543 L166.447687,45.3737543 L190.671139,22.8805483 L190.671139,22.8805483 C191.052092,23.1741316 191.505536,23.378171 192,23.4611785 L192,44.3060559 L192,44.3060559 C190.99808,44.5335399 190.250134,45.4300479 190.250134,46.5013419 C190.250134,47.5726359 190.99808,48.4691439 192,48.696628 L192,69.49194 C192.15062,69.4170883 192.320395,69.375 192.5,69.375 C192.679605,69.375 192.84938,69.4170883 193,69.49194 L193,69.49194 Z M193.621469,70.5897864 L197.757248,73.0712535 C197.994038,73.2133276 198.070821,73.5204577 197.928746,73.7572479 C197.786672,73.994038 197.479542,74.0708205 197.242752,73.9287465 L193.10705,71.4473254 C193.394921,71.2624741 193.593026,70.9499958 193.621469,70.5897864 L193.621469,70.5897864 Z M110,83.6952861 L110,91.3060559 C110.840757,91.4969482 111.502674,92.1589443 111.693865,93 L111.693865,93 L135.306135,93 C135.497326,92.1589443 136.159243,91.4969482 137,91.3060559 L137,73.696628 L137,73.696628 C136.41374,73.5635187 135.914437,73.2013459 135.601054,72.709126 L111.734205,81.2330006 C111.744547,81.3205598 111.749866,81.4096584 111.749866,81.5 C111.749866,82.571294 111.00192,83.467802 110,83.6952861 L110,83.6952861 Z M164,48.696628 L164,91.3060559 L164,91.3060559 C163.159243,91.4969482 162.497326,92.1589443 162.306135,93 L139.693865,93 C139.502674,92.1589443 138.840757,91.4969482 138,91.3060559 L138,73.696628 L138,73.696628 C139.00192,73.4691439 139.749866,72.5726359 139.749866,71.5013419 C139.749866,71.07267 139.630108,70.671984 139.422242,70.3309493 L163.272842,48.3883968 C162.990559,48.2042543 162.752146,47.9584208 162.576711,47.6700143 L164,48.696628 Z M137.5,94.625 C138.12132,94.625 138.625,94.1213203 138.625,93.5 C138.625,92.8786797 138.12132,92.375 137.5,92.375 C136.87868,92.375 136.375,92.8786797 136.375,93.5 C136.375,94.1213203 136.87868,94.625 137.5,94.625 Z M164.5,94.625 C165.12132,94.625 165.625,94.1213203 165.625,93.5 C165.625,92.8786797 165.12132,92.375 164.5,92.375 C163.87868,92.375 163.375,92.8786797 163.375,93.5 C163.375,94.1213203 163.87868,94.625 164.5,94.625 Z M109.5,94.625 C110.12132,94.625 110.625,94.1213203 110.625,93.5 C110.625,92.8786797 110.12132,92.375 109.5,92.375 C108.87868,92.375 108.375,92.8786797 108.375,93.5 C108.375,94.1213203 108.87868,94.625 109.5,94.625 Z M137.5,72.625 C138.12132,72.625 138.625,72.1213203 138.625,71.5 C138.625,70.8786797 138.12132,70.375 137.5,70.375 C136.87868,70.375 136.375,70.8786797 136.375,71.5 C136.375,72.1213203 136.87868,72.625 137.5,72.625 Z M164.5,47.625 C165.12132,47.625 165.625,47.1213203 165.625,46.5 C165.625,45.8786797 165.12132,45.375 164.5,45.375 C163.87868,45.375 163.375,45.8786797 163.375,46.5 C163.375,47.1213203 163.87868,47.625 164.5,47.625 Z M109.5,82.6236581 C110.12132,82.6236581 110.625,82.1199784 110.625,81.4986581 C110.625,80.8773377 110.12132,80.3736581 109.5,80.3736581 C108.87868,80.3736581 108.375,80.8773377 108.375,81.4986581 C108.375,82.1199784 108.87868,82.6236581 109.5,82.6236581 Z M87.5,82.6236581 C88.1213203,82.6236581 88.625,82.1199784 88.625,81.4986581 C88.625,80.8773377 88.1213203,80.3736581 87.5,80.3736581 C86.8786797,80.3736581 86.375,80.8773377 86.375,81.4986581 C86.375,82.1199784 86.8786797,82.6236581 87.5,82.6236581 Z M87.5,94.6236581 C88.1213203,94.6236581 88.625,94.1199784 88.625,93.4986581 C88.625,92.8773377 88.1213203,92.3736581 87.5,92.3736581 C86.8786797,92.3736581 86.375,92.8773377 86.375,93.4986581 C86.375,94.1199784 86.8786797,94.6236581 87.5,94.6236581 Z M58.5,94.6236581 C59.1213203,94.6236581 59.625,94.1199784 59.625,93.4986581 C59.625,92.8773377 59.1213203,92.3736581 58.5,92.3736581 C57.8786797,92.3736581 57.375,92.8773377 57.375,93.4986581 C57.375,94.1199784 57.8786797,94.6236581 58.5,94.6236581 Z M58.5,82.6236581 C59.1213203,82.6236581 59.625,82.1199784 59.625,81.4986581 C59.625,80.8773377 59.1213203,80.3736581 58.5,80.3736581 C57.8786797,80.3736581 57.375,80.8773377 57.375,81.4986581 C57.375,82.1199784 57.8786797,82.6236581 58.5,82.6236581 Z M28.5,82.6236581 C29.1213203,82.6236581 29.625,82.1199784 29.625,81.4986581 C29.625,80.8773377 29.1213203,80.3736581 28.5,80.3736581 C27.8786797,80.3736581 27.375,80.8773377 27.375,81.4986581 C27.375,82.1199784 27.8786797,82.6236581 28.5,82.6236581 Z M28.5,94.6236581 C29.1213203,94.6236581 29.625,94.1199784 29.625,93.4986581 C29.625,92.8773377 29.1213203,92.3736581 28.5,92.3736581 C27.8786797,92.3736581 27.375,92.8773377 27.375,93.4986581 C27.375,94.1199784 27.8786797,94.6236581 28.5,94.6236581 Z M192.5,47.625 C193.12132,47.625 193.625,47.1213203 193.625,46.5 C193.625,45.8786797 193.12132,45.375 192.5,45.375 C191.87868,45.375 191.375,45.8786797 191.375,46.5 C191.375,47.1213203 191.87868,47.625 192.5,47.625 Z M192.5,22 C193.328427,22 194,21.3284271 194,20.5 C194,19.6715729 193.328427,19 192.5,19 C191.671573,19 191,19.6715729 191,20.5 C191,21.3284271 191.671573,22 192.5,22 Z M192.5,94.625 C193.12132,94.625 193.625,94.1213203 193.625,93.5 C193.625,92.8786797 193.12132,92.375 192.5,92.375 C191.87868,92.375 191.375,92.8786797 191.375,93.5 C191.375,94.1213203 191.87868,94.625 192.5,94.625 Z"
                    id="Rectangle-5"
                    fill="#F55C23"
                  />
                  <path
                    d="M362.999924,69.49194 L362.999924,48.696628 L362.999924,48.696628 C363.436931,48.5974065 363.82562,48.3709078 364.125004,48.0581427 L367.242677,49.9287465 C367.479467,50.0708205 367.786597,49.994038 367.928671,49.7572479 C368.070745,49.5204577 367.993962,49.2133276 367.757172,49.0712535 L364.639176,47.2004558 C364.710972,46.9803849 364.74979,46.7453991 364.74979,46.5013419 C364.74979,45.4300479 364.001844,44.5335399 362.999924,44.3060559 L362.999924,23.4611785 L362.999924,23.4611785 C363.708504,23.3422265 364.332848,22.9747274 364.78034,22.4513446 L367.242677,23.9287465 C367.479467,24.0708205 367.786597,23.994038 367.928671,23.7572479 C368.070745,23.5204577 367.993962,23.2133276 367.757172,23.0712535 L365.294748,21.5937988 C365.427039,21.2552485 365.499656,20.88678 365.499656,20.5013419 C365.499656,18.8437465 364.156631,17.5 362.499924,17.5 C360.843218,17.5 359.500193,18.8437465 359.500193,20.5013419 C359.500193,21.1091075 359.680743,21.6746805 359.991107,22.1472957 L335.767107,44.64101 L335.767107,44.64101 C335.406219,44.3944476 334.9699,44.2502684 334.499924,44.2502684 C333.257358,44.2502684 332.250059,45.2581083 332.250059,46.5013419 C332.250059,46.9292933 332.369414,47.3293527 332.576636,47.6700143 L308.725375,69.6131742 C308.372798,69.383631 307.951927,69.2502684 307.499924,69.2502684 C306.257358,69.2502684 305.250059,70.2581083 305.250059,71.5013419 C305.250059,71.5912406 305.255326,71.6799086 305.265568,71.7670536 L281.398174,80.2911227 C280.998715,79.6645016 280.297825,79.2489265 279.499924,79.2489265 C278.42911,79.2489265 277.533018,79.9974077 277.305755,81 L251.694094,81 C251.466831,79.9974077 250.570739,79.2489265 249.499924,79.2489265 C248.42911,79.2489265 247.533018,79.9974077 247.305755,81 L228.694094,81 L228.694094,81 C228.466831,79.9974077 227.570739,79.2489265 226.499924,79.2489265 C225.42911,79.2489265 224.533018,79.9974077 224.305755,81 L196.999924,81 L196.999924,82 L224.305755,82 C224.496546,82.8416934 225.158721,83.5042922 225.999924,83.6952861 L225.999924,91.3047139 C225.158721,91.4957078 224.496546,92.1583066 224.305755,93 L197.999924,93 L197.999924,94 L224.305755,94 C224.533018,95.0025923 225.42911,95.7510735 226.499924,95.7510735 C227.570739,95.7510735 228.466831,95.0025923 228.694094,94 L228.694094,94 L247.305755,94 L247.305755,94 C247.533018,95.0025923 248.42911,95.7510735 249.499924,95.7510735 C250.570739,95.7510735 251.466831,95.0025923 251.694094,94 L277.305452,94 C277.532219,95.0032662 278.428632,95.7524154 279.499924,95.7524154 C280.571217,95.7524154 281.46763,95.0032662 281.694397,94 L305.305452,94 C305.532219,95.0032662 306.428632,95.7524154 307.499924,95.7524154 C308.571217,95.7524154 309.46763,95.0032662 309.694397,94 L309.694397,94 L332.305452,94 C332.532219,95.0032662 333.428632,95.7524154 334.499924,95.7524154 C335.571217,95.7524154 336.46763,95.0032662 336.694397,94 L360.305452,94 C360.495843,94.842331 361.158274,95.5055326 361.999924,95.696628 L361.999924,143 L362.999924,143 L362.999924,95.696628 C363.841575,95.5055326 364.504006,94.842331 364.694397,94 L366.999924,94 L366.999924,93 L364.693789,93 C364.502599,92.1589443 363.840681,91.4969482 362.999924,91.3060559 L362.999924,91.3060559 L362.999924,71.50806 C362.849305,71.5829117 362.67953,71.625 362.499924,71.625 C362.320319,71.625 362.150544,71.5829117 361.999924,71.50806 L361.999924,91.3060559 C361.159168,91.4969482 360.49725,92.1589443 360.30606,93 L360.30606,93 L336.693789,93 L336.693789,93 C336.502599,92.1589443 335.840681,91.4969482 334.999924,91.3060559 L334.999924,48.696628 C336.001844,48.4691439 336.74979,47.5726359 336.74979,46.5013419 C336.74979,46.0904765 336.639775,45.7053203 336.447611,45.3737543 L336.447611,45.3737543 L360.671064,22.8805483 L360.671064,22.8805483 C361.052017,23.1741316 361.505461,23.378171 361.999924,23.4611785 L361.999924,44.3060559 L361.999924,44.3060559 C360.998005,44.5335399 360.250059,45.4300479 360.250059,46.5013419 C360.250059,47.5726359 360.998005,48.4691439 361.999924,48.696628 L361.999924,69.49194 C362.150544,69.4170883 362.320319,69.375 362.499924,69.375 C362.67953,69.375 362.849305,69.4170883 362.999924,69.49194 L362.999924,69.49194 Z M363.621394,70.5897864 L367.757172,73.0712535 C367.993962,73.2133276 368.070745,73.5204577 367.928671,73.7572479 C367.786597,73.994038 367.479467,74.0708205 367.242677,73.9287465 L363.106975,71.4473254 C363.394845,71.2624741 363.59295,70.9499958 363.621394,70.5897864 L363.621394,70.5897864 Z M247.305755,93 L228.694094,93 L228.694094,93 C228.503302,92.1583066 227.841128,91.4957078 226.999924,91.3047139 L226.999924,83.6952861 C227.841128,83.5042922 228.503302,82.8416934 228.694094,82 L247.305755,82 C247.496546,82.8416934 248.158721,83.5042922 248.999924,83.6952861 L248.999924,91.3047139 C248.158721,91.4957078 247.496546,92.1583066 247.305755,93 L247.305755,93 Z M251.694094,93 L277.30606,93 C277.49725,92.1589443 278.159168,91.4969482 278.999924,91.3060559 L278.999924,83.6952861 L278.999924,83.6952861 C278.158721,83.5042922 277.496546,82.8416934 277.305755,82 L251.694094,82 L251.694094,82 C251.503302,82.8416934 250.841128,83.5042922 249.999924,83.6952861 L249.999924,91.3047139 C250.841128,91.4957078 251.503302,92.1583066 251.694094,93 L251.694094,93 Z M279.999924,83.6952861 L279.999924,91.3060559 C280.840681,91.4969482 281.502599,92.1589443 281.693789,93 L281.693789,93 L305.30606,93 C305.49725,92.1589443 306.159168,91.4969482 306.999924,91.3060559 L306.999924,73.696628 L306.999924,73.696628 C306.413665,73.5635187 305.914362,73.2013459 305.600978,72.709126 L281.73413,81.2330006 C281.744471,81.3205598 281.74979,81.4096584 281.74979,81.5 C281.74979,82.571294 281.001844,83.467802 279.999924,83.6952861 L279.999924,83.6952861 Z M333.999924,48.696628 L333.999924,91.3060559 L333.999924,91.3060559 C333.159168,91.4969482 332.49725,92.1589443 332.30606,93 L309.693789,93 C309.502599,92.1589443 308.840681,91.4969482 307.999924,91.3060559 L307.999924,73.696628 L307.999924,73.696628 C309.001844,73.4691439 309.74979,72.5726359 309.74979,71.5013419 C309.74979,71.07267 309.630033,70.671984 309.422166,70.3309493 L333.272767,48.3883968 C332.990484,48.2042543 332.752071,47.9584208 332.576636,47.6700143 L333.999924,48.696628 Z M307.499924,94.625 C308.121245,94.625 308.624924,94.1213203 308.624924,93.5 C308.624924,92.8786797 308.121245,92.375 307.499924,92.375 C306.878604,92.375 306.374924,92.8786797 306.374924,93.5 C306.374924,94.1213203 306.878604,94.625 307.499924,94.625 Z M334.499924,94.625 C335.121245,94.625 335.624924,94.1213203 335.624924,93.5 C335.624924,92.8786797 335.121245,92.375 334.499924,92.375 C333.878604,92.375 333.374924,92.8786797 333.374924,93.5 C333.374924,94.1213203 333.878604,94.625 334.499924,94.625 Z M279.499924,94.625 C280.121245,94.625 280.624924,94.1213203 280.624924,93.5 C280.624924,92.8786797 280.121245,92.375 279.499924,92.375 C278.878604,92.375 278.374924,92.8786797 278.374924,93.5 C278.374924,94.1213203 278.878604,94.625 279.499924,94.625 Z M307.499924,72.625 C308.121245,72.625 308.624924,72.1213203 308.624924,71.5 C308.624924,70.8786797 308.121245,70.375 307.499924,70.375 C306.878604,70.375 306.374924,70.8786797 306.374924,71.5 C306.374924,72.1213203 306.878604,72.625 307.499924,72.625 Z M334.499924,47.625 C335.121245,47.625 335.624924,47.1213203 335.624924,46.5 C335.624924,45.8786797 335.121245,45.375 334.499924,45.375 C333.878604,45.375 333.374924,45.8786797 333.374924,46.5 C333.374924,47.1213203 333.878604,47.625 334.499924,47.625 Z M279.499924,82.6236581 C280.121245,82.6236581 280.624924,82.1199784 280.624924,81.4986581 C280.624924,80.8773377 280.121245,80.3736581 279.499924,80.3736581 C278.878604,80.3736581 278.374924,80.8773377 278.374924,81.4986581 C278.374924,82.1199784 278.878604,82.6236581 279.499924,82.6236581 Z M249.499924,82.6236581 C250.121245,82.6236581 250.624924,82.1199784 250.624924,81.4986581 C250.624924,80.8773377 250.121245,80.3736581 249.499924,80.3736581 C248.878604,80.3736581 248.374924,80.8773377 248.374924,81.4986581 C248.374924,82.1199784 248.878604,82.6236581 249.499924,82.6236581 Z M226.499924,82.6236581 C227.121245,82.6236581 227.624924,82.1199784 227.624924,81.4986581 C227.624924,80.8773377 227.121245,80.3736581 226.499924,80.3736581 C225.878604,80.3736581 225.374924,80.8773377 225.374924,81.4986581 C225.374924,82.1199784 225.878604,82.6236581 226.499924,82.6236581 Z M226.499924,94.6236581 C227.121245,94.6236581 227.624924,94.1199784 227.624924,93.4986581 C227.624924,92.8773377 227.121245,92.3736581 226.499924,92.3736581 C225.878604,92.3736581 225.374924,92.8773377 225.374924,93.4986581 C225.374924,94.1199784 225.878604,94.6236581 226.499924,94.6236581 Z M249.499924,94.6236581 C250.121245,94.6236581 250.624924,94.1199784 250.624924,93.4986581 C250.624924,92.8773377 250.121245,92.3736581 249.499924,92.3736581 C248.878604,92.3736581 248.374924,92.8773377 248.374924,93.4986581 C248.374924,94.1199784 248.878604,94.6236581 249.499924,94.6236581 Z M362.499924,47.625 C363.121245,47.625 363.624924,47.1213203 363.624924,46.5 C363.624924,45.8786797 363.121245,45.375 362.499924,45.375 C361.878604,45.375 361.374924,45.8786797 361.374924,46.5 C361.374924,47.1213203 361.878604,47.625 362.499924,47.625 Z M362.499924,22 C363.328352,22 363.999924,21.3284271 363.999924,20.5 C363.999924,19.6715729 363.328352,19 362.499924,19 C361.671497,19 360.999924,19.6715729 360.999924,20.5 C360.999924,21.3284271 361.671497,22 362.499924,22 Z M362.499924,94.625 C363.121245,94.625 363.624924,94.1213203 363.624924,93.5 C363.624924,92.8786797 363.121245,92.375 362.499924,92.375 C361.878604,92.375 361.374924,92.8786797 361.374924,93.5 C361.374924,94.1213203 361.878604,94.625 362.499924,94.625 Z"
                    id="Rectangle-5-Copy"
                    fill="#F55C23"
                    transform="translate(282.499962, 80.250000) scale(-1, 1) translate(-282.499962, -80.250000) "
                  />
                  <path
                    d="M92.2682896,101.529121 L98.4048966,101.529121 L98.9048966,101.529121 L98.9048966,100.529121 L98.4048966,100.529121 L92.2682896,100.529121 L91.7682896,100.529121 L91.7682896,101.529121 L92.2682896,101.529121 Z M30.90222,109.02779 L37.038827,109.02779 L37.538827,109.02779 L37.538827,108.02779 L37.038827,108.02779 L30.90222,108.02779 L30.40222,108.02779 L30.40222,109.02779 L30.90222,109.02779 Z M30.90222,115.02779 L37.038827,115.02779 L37.538827,115.02779 L37.538827,114.02779 L37.038827,114.02779 L30.90222,114.02779 L30.40222,114.02779 L30.40222,115.02779 L30.90222,115.02779 Z M30.90222,123.02779 L37.038827,123.02779 L37.538827,123.02779 L37.538827,122.02779 L37.038827,122.02779 L30.90222,122.02779 L30.40222,122.02779 L30.40222,123.02779 L30.90222,123.02779 Z M30.90222,101.529121 L37.038827,101.529121 L37.538827,101.529121 L37.538827,100.529121 L37.038827,100.529121 L30.90222,100.529121 L30.40222,100.529121 L30.40222,101.529121 L30.90222,101.529121 Z M51.3575766,101.529121 L57.4941835,101.529121 L57.9941835,101.529121 L57.9941835,100.529121 L57.4941835,100.529121 L51.3575766,100.529121 L50.8575766,100.529121 L50.8575766,101.529121 L51.3575766,101.529121 Z M92.2682896,131.523798 L98.4048966,131.523798 L98.9048966,131.523798 L98.9048966,130.523798 L98.4048966,130.523798 L92.2682896,130.523798 L91.7682896,130.523798 L91.7682896,131.523798 L92.2682896,131.523798 Z M92.2682896,124.025129 L98.4048966,124.025129 L98.9048966,124.025129 L98.9048966,123.025129 L98.4048966,123.025129 L92.2682896,123.025129 L91.7682896,123.025129 L91.7682896,124.025129 L92.2682896,124.025129 Z M92.2682896,116.526459 L98.4048966,116.526459 L98.9048966,116.526459 L98.9048966,115.526459 L98.4048966,115.526459 L92.2682896,115.526459 L91.7682896,115.526459 L91.7682896,116.526459 L92.2682896,116.526459 Z M71.8129331,101.529121 L77.94954,101.529121 L78.44954,101.529121 L78.44954,100.529121 L77.94954,100.529121 L71.8129331,100.529121 L71.3129331,100.529121 L71.3129331,101.529121 L71.8129331,101.529121 Z M71.8129331,108.529121 L77.94954,108.529121 L78.44954,108.529121 L78.44954,107.529121 L77.94954,107.529121 L71.8129331,107.529121 L71.3129331,107.529121 L71.3129331,108.529121 L71.8129331,108.529121 Z M91.8129331,108.529121 L97.94954,108.529121 L98.44954,108.529121 L98.44954,107.529121 L97.94954,107.529121 L91.8129331,107.529121 L91.3129331,107.529121 L91.3129331,108.529121 L91.8129331,108.529121 Z"
                    id="bricks"
                    fill="#F55C23"
                  />
                  <path
                    d="M87.5316955,137 L87.5316955,126.72949 L76.6335576,111.72949 L59,106 L41.3664424,111.72949 L30.4683045,126.72949 L30.4683045,137 L87.5316955,137 Z"
                    id="Polygon-3"
                    stroke="#F55C23"
                    fill="#FFFFFF"
                  />
                  <circle
                    id="Oval-42"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="40.75"
                    cy="111.75"
                    r="1.75"
                  />
                  <circle
                    id="Oval-42-Copy-2"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="76.75"
                    cy="111.75"
                    r="1.75"
                  />
                  <circle
                    id="Oval-42-Copy-7"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="86.75"
                    cy="126.75"
                    r="1.75"
                  />
                  <circle
                    id="Oval-42-Copy"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="59"
                    cy="106"
                    r="1.75"
                  />
                  <g
                    id="pylon-copy"
                    transform="translate(181.596857, 142.941563)"
                    fill="#FFFFFF"
                  >
                    <polygon
                      id="Polygon-3"
                      stroke="#F55C23"
                      transform="translate(16.364285, 4.090183) scale(1, -1) translate(-16.364285, -4.090183) "
                      points="16.3642852 0 31.9276453 2.82624706 25.9829707 7.39921085 6.7455997 7.39921085 0.800925127 2.82624706 "
                    />
                    <ellipse
                      id="Oval-153"
                      stroke="#F65C23"
                      cx="2.38645826"
                      cy="5.11272896"
                      rx="1.70461304"
                      ry="1.70424299"
                    />
                    <ellipse
                      id="Oval-153"
                      stroke="#F65C23"
                      cx="30.3421122"
                      cy="5.11272896"
                      rx="1.70461304"
                      ry="1.70424299"
                    />
                  </g>
                  <ellipse
                    id="Oval-42-Copy-4"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    transform="translate(202.726374, 143.734238) scale(-1, 1) translate(-202.726374, -143.734238) "
                    cx="202.726374"
                    cy="143.734238"
                    rx="1.72637406"
                    ry="1.73423766"
                  />
                  <ellipse
                    id="Oval-42-Copy-3"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    transform="translate(192.726374, 143.734238) scale(-1, 1) translate(-192.726374, -143.734238) "
                    cx="192.726374"
                    cy="143.734238"
                    rx="1.72637406"
                    ry="1.73423766"
                  />
                  <g id="Group" transform="translate(367.000000, 17.000000)">
                    <path
                      d="M86,54.50806 L86,74.3060559 C86.8407567,74.4969482 87.5026741,75.1589443 87.6938646,76 L93,76 L93,77 L87.6944729,77 C87.5040817,77.842331 86.8416508,78.5055326 86,78.696628 L86,126 L85,126 L85,78.696628 C84.1583492,78.5055326 83.4959183,77.842331 83.3055271,77 L83.3055271,77 L59.6944729,77 L59.6944729,77 C59.4677057,78.0032662 58.5712925,78.7524154 57.5,78.7524154 C56.4287075,78.7524154 55.5322943,78.0032662 55.3055271,77 L32.6944729,77 C32.4677057,78.0032662 31.5712925,78.7524154 30.5,78.7524154 C29.4287075,78.7524154 28.5322943,78.0032662 28.3055271,77 L4.69447293,77 L4.69447293,77 C4.46770567,78.0032662 3.57129249,78.7524154 2.5,78.7524154 C1.25743338,78.7524154 0.250134119,77.7445755 0.250134119,76.5013419 C0.250134119,75.4300479 0.99808035,74.5335399 2,74.3060559 L2,66.6952861 C0.99808035,66.467802 0.250134119,65.571294 0.250134119,64.5 C0.250134119,63.2567664 1.25743338,62.2489265 2.5,62.2489265 C3.29790038,62.2489265 3.99879007,62.6645016 4.39824959,63.2911227 L4.39824959,63.2911227 L28.2656431,54.7670536 C28.2554011,54.6799086 28.2501341,54.5912406 28.2501341,54.5013419 C28.2501341,53.2581083 29.2574334,52.2502684 30.5,52.2502684 C30.9520026,52.2502684 31.3728733,52.383631 31.7254503,52.6131742 L31.7254503,52.6131742 L55.5767111,30.6700143 L55.5767111,30.6700143 C55.3694895,30.3293527 55.2501341,29.9292933 55.2501341,29.5013419 C55.2501341,28.2581083 56.2574334,27.2502684 57.5,27.2502684 C57.9699755,27.2502684 58.4062942,27.3944476 58.7671826,27.64101 L82.9911826,5.14729569 C82.680819,4.67468048 82.5002682,4.10910746 82.5002682,3.50134191 C82.5002682,1.84374654 83.8432939,0.5 85.5,0.5 C87.1567061,0.5 88.4997318,1.84374654 88.4997318,3.50134191 C88.4997318,3.88678004 88.427115,4.25524852 88.2948233,4.59379876 L90.7572479,6.07125354 C90.994038,6.21332762 91.0708205,6.52045774 90.9287465,6.75724788 C90.7866724,6.99403801 90.4795423,7.07082054 90.2427521,6.92874646 L87.7804156,5.45134457 C87.3329231,5.97472736 86.70858,6.34222649 86,6.46117854 L86,6.46117854 L86,27.3060559 L86,27.3060559 C87.0019197,27.5335399 87.7498659,28.4300479 87.7498659,29.5013419 C87.7498659,29.7453991 87.7110476,29.9803849 87.6392516,30.2004558 L90.7572479,32.0712535 C90.994038,32.2133276 91.0708205,32.5204577 90.9287465,32.7572479 C90.7866724,32.994038 90.4795423,33.0708205 90.2427521,32.9287465 L87.1250792,31.0581427 C86.8256955,31.3709078 86.4370061,31.5974065 86,31.696628 L86,52.49194 C86.3704296,52.6760278 86.625,53.0582848 86.625,53.5 C86.625,53.5302219 86.6238083,53.5601656 86.6214693,53.5897864 L90.7572479,56.0712535 C90.994038,56.2133276 91.0708205,56.5204577 90.9287465,56.7572479 C90.7866724,56.994038 90.4795423,57.0708205 90.2427521,56.9287465 L86.1070504,54.4473254 C86.0726064,54.4694431 86.0368773,54.4897336 86,54.50806 L86,54.50806 Z M85,54.50806 L85,74.3060559 C84.1592433,74.4969482 83.4973259,75.1589443 83.3061354,76 L83.3061354,76 L59.6938646,76 L59.6938646,76 C59.5026741,75.1589443 58.8407567,74.4969482 58,74.3060559 L58,31.696628 C59.0019197,31.4691439 59.7498659,30.5726359 59.7498659,29.5013419 C59.7498659,29.0904765 59.6398508,28.7053203 59.4476867,28.3737543 L59.4476867,28.3737543 L83.6711393,5.8805483 L83.6711393,5.8805483 C84.0520923,6.1741316 84.5055363,6.37817101 85,6.46117854 L85,27.3060559 L85,27.3060559 C83.9980803,27.5335399 83.2501341,28.4300479 83.2501341,29.5013419 C83.2501341,30.5726359 83.9980803,31.4691439 85,31.696628 L85,52.49194 C85.1506199,52.4170883 85.3203948,52.375 85.5,52.375 C85.6796052,52.375 85.8493801,52.4170883 86,52.49194 L85,54.50806 Z M4.73420518,64.2330006 L28.601054,55.709126 C28.9144371,56.2013459 29.4137402,56.5635187 30,56.696628 L30,74.3060559 C29.1592433,74.4969482 28.4973259,75.1589443 28.3061354,76 L4.69386458,76 C4.50267409,75.1589443 3.84075674,74.4969482 3,74.3060559 L3,66.6952861 C4.00191965,66.467802 4.74986588,65.571294 4.74986588,64.5 C4.74986588,64.4096584 4.7445469,64.3205598 4.73420518,64.2330006 L4.73420518,64.2330006 Z M56.2728421,31.3883968 L32.4222415,53.3309493 L32.4222415,53.3309493 C32.6301083,53.671984 32.7498659,54.07267 32.7498659,54.5013419 C32.7498659,55.5726359 32.0019197,56.4691439 31,56.696628 L31,74.3060559 C31.8407567,74.4969482 32.5026741,75.1589443 32.6938646,76 L55.3061354,76 C55.4973259,75.1589443 56.1592433,74.4969482 57,74.3060559 L57,31.696628 C56.7371633,31.6369514 56.4918047,31.5312334 56.2728421,31.3883968 L56.2728421,31.3883968 Z M30.5,77.625 C31.1213203,77.625 31.625,77.1213203 31.625,76.5 C31.625,75.8786797 31.1213203,75.375 30.5,75.375 C29.8786797,75.375 29.375,75.8786797 29.375,76.5 C29.375,77.1213203 29.8786797,77.625 30.5,77.625 Z M57.5,77.625 C58.1213203,77.625 58.625,77.1213203 58.625,76.5 C58.625,75.8786797 58.1213203,75.375 57.5,75.375 C56.8786797,75.375 56.375,75.8786797 56.375,76.5 C56.375,77.1213203 56.8786797,77.625 57.5,77.625 Z M2.5,77.625 C3.12132034,77.625 3.625,77.1213203 3.625,76.5 C3.625,75.8786797 3.12132034,75.375 2.5,75.375 C1.87867966,75.375 1.375,75.8786797 1.375,76.5 C1.375,77.1213203 1.87867966,77.625 2.5,77.625 Z M30.5,55.625 C31.1213203,55.625 31.625,55.1213203 31.625,54.5 C31.625,53.8786797 31.1213203,53.375 30.5,53.375 C29.8786797,53.375 29.375,53.8786797 29.375,54.5 C29.375,55.1213203 29.8786797,55.625 30.5,55.625 Z M57.5,30.625 C58.1213203,30.625 58.625,30.1213203 58.625,29.5 C58.625,28.8786797 58.1213203,28.375 57.5,28.375 C56.8786797,28.375 56.375,28.8786797 56.375,29.5 C56.375,30.1213203 56.8786797,30.625 57.5,30.625 Z M2.5,65.6236581 C3.12132034,65.6236581 3.625,65.1199784 3.625,64.4986581 C3.625,63.8773377 3.12132034,63.3736581 2.5,63.3736581 C1.87867966,63.3736581 1.375,63.8773377 1.375,64.4986581 C1.375,65.1199784 1.87867966,65.6236581 2.5,65.6236581 Z M85.5,30.625 C86.1213203,30.625 86.625,30.1213203 86.625,29.5 C86.625,28.8786797 86.1213203,28.375 85.5,28.375 C84.8786797,28.375 84.375,28.8786797 84.375,29.5 C84.375,30.1213203 84.8786797,30.625 85.5,30.625 Z M85.5,5 C86.3284271,5 87,4.32842712 87,3.5 C87,2.67157288 86.3284271,2 85.5,2 C84.6715729,2 84,2.67157288 84,3.5 C84,4.32842712 84.6715729,5 85.5,5 Z M85.5,77.625 C86.1213203,77.625 86.625,77.1213203 86.625,76.5 C86.625,75.8786797 86.1213203,75.375 85.5,75.375 C84.8786797,75.375 84.375,75.8786797 84.375,76.5 C84.375,77.1213203 84.8786797,77.625 85.5,77.625 Z"
                      id="Rectangle-5-Copy-3"
                      fill="#F55C23"
                    />
                    <g
                      id="pylon-copy-2"
                      transform="translate(74.596857, 125.941563)"
                      fill="#FFFFFF"
                    >
                      <polygon
                        id="Polygon-3"
                        stroke="#F55C23"
                        transform="translate(16.364285, 4.090183) scale(1, -1) translate(-16.364285, -4.090183) "
                        points="16.3642852 0 31.9276453 2.82624706 25.9829707 7.39921085 6.7455997 7.39921085 0.800925127 2.82624706 "
                      />
                      <ellipse
                        id="Oval-153"
                        stroke="#F65C23"
                        cx="2.38645826"
                        cy="5.11272896"
                        rx="1.70461304"
                        ry="1.70424299"
                      />
                      <ellipse
                        id="Oval-153"
                        stroke="#F65C23"
                        cx="30.3421122"
                        cy="5.11272896"
                        rx="1.70461304"
                        ry="1.70424299"
                      />
                    </g>
                    <ellipse
                      id="Oval-42-Copy-5"
                      stroke="#F65C23"
                      fill="#FFFFFF"
                      transform="translate(95.726374, 126.734238) scale(-1, 1) translate(-95.726374, -126.734238) "
                      cx="95.7263741"
                      cy="126.734238"
                      rx="1.72637406"
                      ry="1.73423766"
                    />
                    <ellipse
                      id="Oval-42-Copy-6"
                      stroke="#F65C23"
                      fill="#FFFFFF"
                      transform="translate(85.726374, 126.734238) scale(-1, 1) translate(-85.726374, -126.734238) "
                      cx="85.7263741"
                      cy="126.734238"
                      rx="1.72637406"
                      ry="1.73423766"
                    />
                  </g>
                  <path
                    d="M658,69.49194 L658,48.696628 L658,48.696628 C658.437006,48.5974065 658.825695,48.3709078 659.125079,48.0581427 L662.242752,49.9287465 C662.479542,50.0708205 662.786672,49.994038 662.928746,49.7572479 C663.070821,49.5204577 662.994038,49.2133276 662.757248,49.0712535 L659.639252,47.2004558 C659.711048,46.9803849 659.749866,46.7453991 659.749866,46.5013419 C659.749866,45.4300479 659.00192,44.5335399 658,44.3060559 L658,23.4611785 L658,23.4611785 C658.70858,23.3422265 659.332923,22.9747274 659.780416,22.4513446 L662.242752,23.9287465 C662.479542,24.0708205 662.786672,23.994038 662.928746,23.7572479 C663.070821,23.5204577 662.994038,23.2133276 662.757248,23.0712535 L660.294823,21.5937988 C660.427115,21.2552485 660.499732,20.88678 660.499732,20.5013419 C660.499732,18.8437465 659.156706,17.5 657.5,17.5 C655.843294,17.5 654.500268,18.8437465 654.500268,20.5013419 C654.500268,21.1091075 654.680819,21.6746805 654.991183,22.1472957 L630.767183,44.64101 L630.767183,44.64101 C630.406294,44.3944476 629.969976,44.2502684 629.5,44.2502684 C628.257433,44.2502684 627.250134,45.2581083 627.250134,46.5013419 C627.250134,46.9292933 627.369489,47.3293527 627.576711,47.6700143 L603.72545,69.6131742 C603.372873,69.383631 602.952003,69.2502684 602.5,69.2502684 C601.257433,69.2502684 600.250134,70.2581083 600.250134,71.5013419 C600.250134,71.5912406 600.255401,71.6799086 600.265643,71.7670536 L576.39825,80.2911227 C575.99879,79.6645016 575.2979,79.2489265 574.5,79.2489265 C573.429185,79.2489265 572.533094,79.9974077 572.305831,81 L554.694169,81 C554.466906,79.9974077 553.570815,79.2489265 552.5,79.2489265 C551.429185,79.2489265 550.533094,79.9974077 550.305831,81 L525.694169,81 L525.694169,81 C525.466906,79.9974077 524.570815,79.2489265 523.5,79.2489265 C522.429185,79.2489265 521.533094,79.9974077 521.305831,81 L495.694169,81 C495.466906,79.9974077 494.570815,79.2489265 493.5,79.2489265 C492.429185,79.2489265 491.533094,79.9974077 491.305831,81 L456,81 L456,82 L491.305831,82 C491.533094,83.0025923 492.429185,83.7510735 493.5,83.7510735 C494.570815,83.7510735 495.466906,83.0025923 495.694169,82 L495.694169,82 L521.305831,82 C521.533094,83.0025923 522.429185,83.7510735 523.5,83.7510735 C524.570815,83.7510735 525.466906,83.0025923 525.694169,82 L550.305831,82 C550.533094,83.0025923 551.429185,83.7510735 552.5,83.7510735 C553.570815,83.7510735 554.466906,83.0025923 554.694169,82 L554.694169,82 L572.305831,82 C572.496622,82.8416934 573.158796,83.5042922 574,83.6952861 L574,83.6952861 L574,91.3060559 C573.159243,91.4969482 572.497326,92.1589443 572.306135,93 L554.694169,93 L554.694169,93 C554.466906,91.9974077 553.570815,91.2489265 552.5,91.2489265 C551.429185,91.2489265 550.533094,91.9974077 550.305831,93 L525.694169,93 C525.466906,91.9974077 524.570815,91.2489265 523.5,91.2489265 C522.429185,91.2489265 521.533094,91.9974077 521.305831,93 L495.694169,93 C495.466906,91.9974077 494.570815,91.2489265 493.5,91.2489265 C492.429185,91.2489265 491.533094,91.9974077 491.305831,93 L456,93 L456,94 L491.305831,94 C491.533094,95.0025923 492.429185,95.7510735 493.5,95.7510735 C494.570815,95.7510735 495.466906,95.0025923 495.694169,94 L521.305831,94 C521.533094,95.0025923 522.429185,95.7510735 523.5,95.7510735 C524.570815,95.7510735 525.466906,95.0025923 525.694169,94 L525.694169,94 L550.305831,94 C550.533094,95.0025923 551.429185,95.7510735 552.5,95.7510735 C553.570815,95.7510735 554.466906,95.0025923 554.694169,94 L572.305527,94 C572.495918,94.842331 573.158349,95.5055326 574,95.696628 L574,144 L575,144 L575,95.696628 C575.841651,95.5055326 576.504082,94.842331 576.694473,94 L600.305527,94 C600.532294,95.0032662 601.428708,95.7524154 602.5,95.7524154 C603.571292,95.7524154 604.467706,95.0032662 604.694473,94 L627.305527,94 C627.532294,95.0032662 628.428708,95.7524154 629.5,95.7524154 C630.571292,95.7524154 631.467706,95.0032662 631.694473,94 L655.305527,94 C655.495918,94.842331 656.158349,95.5055326 657,95.696628 L657,143 L658,143 L658,95.696628 C658.841651,95.5055326 659.504082,94.842331 659.694473,94 L665,94 L665,93 L659.693865,93 C659.502674,92.1589443 658.840757,91.4969482 658,91.3060559 L658,91.3060559 L658,71.50806 C657.84938,71.5829117 657.679605,71.625 657.5,71.625 C657.320395,71.625 657.15062,71.5829117 657,71.50806 L657,91.3060559 C656.159243,91.4969482 655.497326,92.1589443 655.306135,93 L655.306135,93 L631.693865,93 L631.693865,93 C631.502674,92.1589443 630.840757,91.4969482 630,91.3060559 L630,48.696628 C631.00192,48.4691439 631.749866,47.5726359 631.749866,46.5013419 C631.749866,46.0904765 631.639851,45.7053203 631.447687,45.3737543 L631.447687,45.3737543 L655.671139,22.8805483 L655.671139,22.8805483 C656.052092,23.1741316 656.505536,23.378171 657,23.4611785 L657,44.3060559 L657,44.3060559 C655.99808,44.5335399 655.250134,45.4300479 655.250134,46.5013419 C655.250134,47.5726359 655.99808,48.4691439 657,48.696628 L657,69.49194 C657.15062,69.4170883 657.320395,69.375 657.5,69.375 C657.679605,69.375 657.84938,69.4170883 658,69.49194 L658,69.49194 Z M658.621469,70.5897864 L662.757248,73.0712535 C662.994038,73.2133276 663.070821,73.5204577 662.928746,73.7572479 C662.786672,73.994038 662.479542,74.0708205 662.242752,73.9287465 L658.10705,71.4473254 C658.394921,71.2624741 658.593026,70.9499958 658.621469,70.5897864 L658.621469,70.5897864 Z M575,83.6952861 L575,91.3060559 C575.840757,91.4969482 576.502674,92.1589443 576.693865,93 L576.693865,93 L600.306135,93 C600.497326,92.1589443 601.159243,91.4969482 602,91.3060559 L602,73.696628 L602,73.696628 C601.41374,73.5635187 600.914437,73.2013459 600.601054,72.709126 L576.734205,81.2330006 C576.744547,81.3205598 576.749866,81.4096584 576.749866,81.5 C576.749866,82.571294 576.00192,83.467802 575,83.6952861 L575,83.6952861 Z M629,48.696628 L629,91.3060559 L629,91.3060559 C628.159243,91.4969482 627.497326,92.1589443 627.306135,93 L604.693865,93 C604.502674,92.1589443 603.840757,91.4969482 603,91.3060559 L603,73.696628 L603,73.696628 C604.00192,73.4691439 604.749866,72.5726359 604.749866,71.5013419 C604.749866,71.07267 604.630108,70.671984 604.422242,70.3309493 L628.272842,48.3883968 C627.990559,48.2042543 627.752146,47.9584208 627.576711,47.6700143 L629,48.696628 Z M602.5,94.625 C603.12132,94.625 603.625,94.1213203 603.625,93.5 C603.625,92.8786797 603.12132,92.375 602.5,92.375 C601.87868,92.375 601.375,92.8786797 601.375,93.5 C601.375,94.1213203 601.87868,94.625 602.5,94.625 Z M629.5,94.625 C630.12132,94.625 630.625,94.1213203 630.625,93.5 C630.625,92.8786797 630.12132,92.375 629.5,92.375 C628.87868,92.375 628.375,92.8786797 628.375,93.5 C628.375,94.1213203 628.87868,94.625 629.5,94.625 Z M574.5,94.625 C575.12132,94.625 575.625,94.1213203 575.625,93.5 C575.625,92.8786797 575.12132,92.375 574.5,92.375 C573.87868,92.375 573.375,92.8786797 573.375,93.5 C573.375,94.1213203 573.87868,94.625 574.5,94.625 Z M602.5,72.625 C603.12132,72.625 603.625,72.1213203 603.625,71.5 C603.625,70.8786797 603.12132,70.375 602.5,70.375 C601.87868,70.375 601.375,70.8786797 601.375,71.5 C601.375,72.1213203 601.87868,72.625 602.5,72.625 Z M629.5,47.625 C630.12132,47.625 630.625,47.1213203 630.625,46.5 C630.625,45.8786797 630.12132,45.375 629.5,45.375 C628.87868,45.375 628.375,45.8786797 628.375,46.5 C628.375,47.1213203 628.87868,47.625 629.5,47.625 Z M574.5,82.6236581 C575.12132,82.6236581 575.625,82.1199784 575.625,81.4986581 C575.625,80.8773377 575.12132,80.3736581 574.5,80.3736581 C573.87868,80.3736581 573.375,80.8773377 573.375,81.4986581 C573.375,82.1199784 573.87868,82.6236581 574.5,82.6236581 Z M552.5,82.6236581 C553.12132,82.6236581 553.625,82.1199784 553.625,81.4986581 C553.625,80.8773377 553.12132,80.3736581 552.5,80.3736581 C551.87868,80.3736581 551.375,80.8773377 551.375,81.4986581 C551.375,82.1199784 551.87868,82.6236581 552.5,82.6236581 Z M552.5,94.6236581 C553.12132,94.6236581 553.625,94.1199784 553.625,93.4986581 C553.625,92.8773377 553.12132,92.3736581 552.5,92.3736581 C551.87868,92.3736581 551.375,92.8773377 551.375,93.4986581 C551.375,94.1199784 551.87868,94.6236581 552.5,94.6236581 Z M523.5,94.6236581 C524.12132,94.6236581 524.625,94.1199784 524.625,93.4986581 C524.625,92.8773377 524.12132,92.3736581 523.5,92.3736581 C522.87868,92.3736581 522.375,92.8773377 522.375,93.4986581 C522.375,94.1199784 522.87868,94.6236581 523.5,94.6236581 Z M523.5,82.6236581 C524.12132,82.6236581 524.625,82.1199784 524.625,81.4986581 C524.625,80.8773377 524.12132,80.3736581 523.5,80.3736581 C522.87868,80.3736581 522.375,80.8773377 522.375,81.4986581 C522.375,82.1199784 522.87868,82.6236581 523.5,82.6236581 Z M493.5,82.6236581 C494.12132,82.6236581 494.625,82.1199784 494.625,81.4986581 C494.625,80.8773377 494.12132,80.3736581 493.5,80.3736581 C492.87868,80.3736581 492.375,80.8773377 492.375,81.4986581 C492.375,82.1199784 492.87868,82.6236581 493.5,82.6236581 Z M493.5,94.6236581 C494.12132,94.6236581 494.625,94.1199784 494.625,93.4986581 C494.625,92.8773377 494.12132,92.3736581 493.5,92.3736581 C492.87868,92.3736581 492.375,92.8773377 492.375,93.4986581 C492.375,94.1199784 492.87868,94.6236581 493.5,94.6236581 Z M657.5,47.625 C658.12132,47.625 658.625,47.1213203 658.625,46.5 C658.625,45.8786797 658.12132,45.375 657.5,45.375 C656.87868,45.375 656.375,45.8786797 656.375,46.5 C656.375,47.1213203 656.87868,47.625 657.5,47.625 Z M657.5,22 C658.328427,22 659,21.3284271 659,20.5 C659,19.6715729 658.328427,19 657.5,19 C656.671573,19 656,19.6715729 656,20.5 C656,21.3284271 656.671573,22 657.5,22 Z M657.5,94.625 C658.12132,94.625 658.625,94.1213203 658.625,93.5 C658.625,92.8786797 658.12132,92.375 657.5,92.375 C656.87868,92.375 656.375,92.8786797 656.375,93.5 C656.375,94.1213203 656.87868,94.625 657.5,94.625 Z"
                    id="Rectangle-5-Copy-2"
                    fill="#F55C23"
                    transform="translate(560.500000, 80.750000) scale(-1, 1) translate(-560.500000, -80.750000) "
                  />
                  <path
                    d="M563.038827,101.529121 L556.90222,101.529121 L556.40222,101.529121 L556.40222,100.529121 L556.90222,100.529121 L563.038827,100.529121 L563.538827,100.529121 L563.538827,101.529121 L563.038827,101.529121 Z M624.404897,109.02779 L618.26829,109.02779 L617.76829,109.02779 L617.76829,108.02779 L618.26829,108.02779 L624.404897,108.02779 L624.904897,108.02779 L624.904897,109.02779 L624.404897,109.02779 Z M624.404897,115.02779 L618.26829,115.02779 L617.76829,115.02779 L617.76829,114.02779 L618.26829,114.02779 L624.404897,114.02779 L624.904897,114.02779 L624.904897,115.02779 L624.404897,115.02779 Z M624.404897,123.02779 L618.26829,123.02779 L617.76829,123.02779 L617.76829,122.02779 L618.26829,122.02779 L624.404897,122.02779 L624.904897,122.02779 L624.904897,123.02779 L624.404897,123.02779 Z M624.404897,101.529121 L618.26829,101.529121 L617.76829,101.529121 L617.76829,100.529121 L618.26829,100.529121 L624.404897,100.529121 L624.904897,100.529121 L624.904897,101.529121 L624.404897,101.529121 Z M603.94954,101.529121 L597.812933,101.529121 L597.312933,101.529121 L597.312933,100.529121 L597.812933,100.529121 L603.94954,100.529121 L604.44954,100.529121 L604.44954,101.529121 L603.94954,101.529121 Z M563.038827,131.523798 L556.90222,131.523798 L556.40222,131.523798 L556.40222,130.523798 L556.90222,130.523798 L563.038827,130.523798 L563.538827,130.523798 L563.538827,131.523798 L563.038827,131.523798 Z M563.038827,124.025129 L556.90222,124.025129 L556.40222,124.025129 L556.40222,123.025129 L556.90222,123.025129 L563.038827,123.025129 L563.538827,123.025129 L563.538827,124.025129 L563.038827,124.025129 Z M563.038827,116.526459 L556.90222,116.526459 L556.40222,116.526459 L556.40222,115.526459 L556.90222,115.526459 L563.038827,115.526459 L563.538827,115.526459 L563.538827,116.526459 L563.038827,116.526459 Z M583.494184,101.529121 L577.357577,101.529121 L576.857577,101.529121 L576.857577,100.529121 L577.357577,100.529121 L583.494184,100.529121 L583.994184,100.529121 L583.994184,101.529121 L583.494184,101.529121 Z M583.494184,108.529121 L577.357577,108.529121 L576.857577,108.529121 L576.857577,107.529121 L577.357577,107.529121 L583.494184,107.529121 L583.994184,107.529121 L583.994184,108.529121 L583.494184,108.529121 Z M563.494184,108.529121 L557.357577,108.529121 L556.857577,108.529121 L556.857577,107.529121 L557.357577,107.529121 L563.494184,107.529121 L563.994184,107.529121 L563.994184,108.529121 L563.494184,108.529121 Z"
                    id="bricks-copy"
                    fill="#F55C23"
                  />
                  <path
                    d="M556.468305,137 L556.468305,126.72949 L567.366442,111.72949 L585,106 L602.633558,111.72949 L613.531695,126.72949 L613.531695,137 L556.468305,137 Z"
                    id="Polygon-3-Copy"
                    stroke="#F55C23"
                    fill="#FFFFFF"
                  />
                  <circle
                    id="Oval-42-Copy-8"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="566.75"
                    cy="111.75"
                    r="1.75"
                  />
                  <circle
                    id="Oval-42-Copy-9"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="602.75"
                    cy="111.75"
                    r="1.75"
                  />
                  <circle
                    id="Oval-42-Copy-10"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="612.75"
                    cy="126.75"
                    r="1.75"
                  />
                  <circle
                    id="Oval-42-Copy-11"
                    stroke="#F65C23"
                    fill="#FFFFFF"
                    cx="585"
                    cy="106"
                    r="1.75"
                  />
                </g>
              </g>
            </svg>
          </div>
          <div className="brand-mountain-2">
            <svg
              width="514px"
              height="175px"
              viewBox="0 0 514 175"
              version="1.1"
            >
              <path
                fill="#fff"
                d="M41.5,45 L78,33 L78,74.5 L2.5,92 L41.5,45 Z"
                id="Path"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M77.5,32.5 L143,45.5 L76.5,75.5 L77.5,32.5 Z"
                id="Path-Copy-8"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M1.5,91 L78,73.5 L87,119.5 L41.5,149 L1.5,91 Z"
                id="Path-Copy"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M77.5000001,74.5 L143,44 L174,46 L86.0000001,119.5 L77.5000001,74.5 Z"
                id="Path-Copy-7"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M142.5,45 L205,25.5 L229,39.5 L173.5,47.5 L142.5,45 Z"
                id="Path-Copy-9"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M158.499999,99 L225.499999,80.5 L270.999999,87.5 L226.999999,125 L158.499999,99 Z"
                id="Path-Copy-2"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M156.499999,101.5 L172.999999,47 L226.499999,39 L226.499999,81 L156.499999,101.5 Z"
                id="Path-Copy-11"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M243.000001,88.5 L225.5,43.5 L288,39 L288,81.5 L243.000001,88.5 Z"
                id="Path-Copy-12"
                stroke="#B6CCE5"
                transform="translate(256.750000, 63.750000) scale(-1, 1) translate(-256.750000, -63.750000) "
              />
              <path
                fill="#fff"
                d="M286.5,44.5 L342.5,64 L319.5,110.5 L270,86.5 L286.5,44.5 Z"
                id="Path-Copy-4"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M341.5,64 L390.5,111 L396.5,155 L317,109 L341.5,64 Z"
                id="Path-Copy-10"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M389,111 L505,149 L396,154 L389,111 Z"
                id="Path-Copy-13"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M321,110 L397,154 L282,149 L321,110 Z"
                id="Path-Copy-14"
                stroke="#4A90E2"
              />
              <path
                fill="#fff"
                d="M247.5,20.5 L287,44.5 L226.5,40 L247.5,20.5 Z"
                id="Path-Copy-5"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M221.999999,13 L248.499999,20.5 L227.499999,40 L203.999999,26 L221.999999,13 Z"
                id="Path-Copy-6"
                stroke="#B6CCE5"
              />
              <path
                fill="#fff"
                d="M228.499999,126.000001 L284.000003,148.499999 L224.500001,171.000001 L158.500001,148.499999 L228.499999,126.000001 Z"
                id="fg-geometry"
                stroke="#4A90E2"
              />
              <polygon
                fill="#fff"
                id="Path"
                stroke="#4A90E2"
                points="158.5 99 159.5 149 42 149 "
              />
              <path
                fill="#fff"
                d="M271.000001,86.0000002 L321.5,110.5 L283,149.5 L225,125.5 L271.000001,86.0000002 Z"
                id="Path-Copy-3"
                stroke="#4A90E2"
              />
              <path
                fill="#fff"
                d="M42.2061,154.838108 C45.4069681,154.838108 48.0017844,152.243855 48.0017844,149.043682 C48.0017844,145.843509 45.4069681,143.249256 42.2061,143.249256 C39.0052319,143.249256 36.4104157,145.843509 36.4104157,149.043682 C36.4104157,152.243855 39.0052319,154.838108 42.2061,154.838108 Z M159.483477,154.838108 C162.684345,154.838108 165.279162,152.243855 165.279162,149.043682 C165.279162,145.843509 162.684345,143.249256 159.483477,143.249256 C156.282609,143.249256 153.687793,145.843509 153.687793,149.043682 C153.687793,152.243855 156.282609,154.838108 159.483477,154.838108 Z M282.215617,154.838108 C285.416485,154.838108 288.011301,152.243855 288.011301,149.043682 C288.011301,145.843509 285.416485,143.249256 282.215617,143.249256 C279.014748,143.249256 276.419932,145.843509 276.419932,149.043682 C276.419932,152.243855 279.014748,154.838108 282.215617,154.838108 Z M505.860848,154.156411 C509.061716,154.156411 511.656532,151.562158 511.656532,148.361985 C511.656532,145.161811 509.061716,142.567558 505.860848,142.567558 C502.65998,142.567558 500.065164,145.161811 500.065164,148.361985 C500.065164,151.562158 502.65998,154.156411 505.860848,154.156411 Z M396.083768,159.950837 C399.284636,159.950837 401.879452,157.356584 401.879452,154.156411 C401.879452,150.956238 399.284636,148.361985 396.083768,148.361985 C392.8829,148.361985 390.288084,150.956238 390.288084,154.156411 C390.288084,157.356584 392.8829,159.950837 396.083768,159.950837 Z M319.717104,115.981368 C322.917972,115.981368 325.512788,113.387115 325.512788,110.186942 C325.512788,106.986769 322.917972,104.392516 319.717104,104.392516 C316.516235,104.392516 313.921419,106.986769 313.921419,110.186942 C313.921419,113.387115 316.516235,115.981368 319.717104,115.981368 Z M270.624248,92.8036633 C273.825116,92.8036633 276.419932,90.2094103 276.419932,87.0092371 C276.419932,83.8090639 273.825116,81.214811 270.624248,81.214811 C267.42338,81.214811 264.828563,83.8090639 264.828563,87.0092371 C264.828563,90.2094103 267.42338,92.8036633 270.624248,92.8036633 Z M229.03169,131.660403 C232.232558,131.660403 234.827374,129.06615 234.827374,125.865977 C234.827374,122.665804 232.232558,120.071551 229.03169,120.071551 C225.830822,120.071551 223.236005,122.665804 223.236005,125.865977 C223.236005,129.06615 225.830822,131.660403 229.03169,131.660403 Z M158.119787,104.392516 C161.320655,104.392516 163.915471,101.798263 163.915471,98.5980894 C163.915471,95.3979162 161.320655,92.8036633 158.119787,92.8036633 C154.918919,92.8036633 152.324103,95.3979162 152.324103,98.5980894 C152.324103,101.798263 154.918919,104.392516 158.119787,104.392516 Z M224.940618,173.925629 C228.141486,173.925629 230.736303,171.331376 230.736303,168.131203 C230.736303,164.93103 228.141486,162.336777 224.940618,162.336777 C221.73975,162.336777 219.144934,164.93103 219.144934,168.131203 C219.144934,171.331376 221.73975,173.925629 224.940618,173.925629 Z"
                id="fg-points"
                stroke="#4A90E2"
              />
              <path
                fill="#fff"
                d="M78.0029739,76.4429306 C79.5092648,76.4429306 80.7303548,75.2221057 80.7303548,73.7161419 C80.7303548,72.210178 79.5092648,70.9893531 78.0029739,70.9893531 C76.4966831,70.9893531 75.275593,72.210178 75.275593,73.7161419 C75.275593,75.2221057 76.4966831,76.4429306 78.0029739,76.4429306 Z M3,94.4779116 C4.50629086,94.4779116 5.72738087,93.2570867 5.72738087,91.7511228 C5.72738087,90.245159 4.50629086,89.024334 3,89.024334 C1.49370914,89.024334 0.27261913,90.245159 0.27261913,91.7511228 C0.27261913,93.2570867 1.49370914,94.4779116 3,94.4779116 Z M42.5470226,48.167594 C44.0533135,48.167594 45.2744035,46.9467691 45.2744035,45.4408052 C45.2744035,43.9348413 44.0533135,42.7140164 42.5470226,42.7140164 C41.0407318,42.7140164 39.8196417,43.9348413 39.8196417,45.4408052 C39.8196417,46.9467691 41.0407318,48.167594 42.5470226,48.167594 Z M78.0029739,35.541099 C79.5092648,35.541099 80.7303548,34.3202741 80.7303548,32.8143102 C80.7303548,31.3083464 79.5092648,30.0875214 78.0029739,30.0875214 C76.4966831,30.0875214 75.275593,31.3083464 75.275593,32.8143102 C75.275593,34.3202741 76.4966831,35.541099 78.0029739,35.541099 Z M142.77827,47.1299513 C144.28456,47.1299513 145.50565,45.9091264 145.50565,44.4031625 C145.50565,42.8971987 144.28456,41.6763737 142.77827,41.6763737 C141.271979,41.6763737 140.050889,42.8971987 140.050889,44.4031625 C140.050889,45.9091264 141.271979,47.1299513 142.77827,47.1299513 Z M86.8669617,122.116643 C88.3732526,122.116643 89.5943426,120.895818 89.5943426,119.389854 C89.5943426,117.88389 88.3732526,116.663065 86.8669617,116.663065 C85.3606709,116.663065 84.1395809,117.88389 84.1395809,119.389854 C84.1395809,120.895818 85.3606709,122.116643 86.8669617,122.116643 Z M246.418743,23.2705495 C247.925033,23.2705495 249.146123,22.0497246 249.146123,20.5437607 C249.146123,19.0377969 247.925033,17.8169719 246.418743,17.8169719 C244.912452,17.8169719 243.691362,19.0377969 243.691362,20.5437607 C243.691362,22.0497246 244.912452,23.2705495 246.418743,23.2705495 Z M173.461304,49.8567401 C174.967595,49.8567401 176.188685,48.6359151 176.188685,47.1299513 C176.188685,45.6239874 174.967595,44.4031625 173.461304,44.4031625 C171.955013,44.4031625 170.733923,45.6239874 170.733923,47.1299513 C170.733923,48.6359151 171.955013,49.8567401 173.461304,49.8567401 Z M204.144339,28.0424299 C205.65063,28.0424299 206.87172,26.8216049 206.87172,25.3156411 C206.87172,23.8096772 205.65063,22.5888523 204.144339,22.5888523 C202.638048,22.5888523 201.416958,23.8096772 201.416958,25.3156411 C201.416958,26.8216049 202.638048,28.0424299 204.144339,28.0424299 Z M225.963386,83.2599026 C227.469677,83.2599026 228.690767,82.0390776 228.690767,80.5331138 C228.690767,79.0271499 227.469677,77.806325 225.963386,77.806325 C224.457095,77.806325 223.236005,79.0271499 223.236005,80.5331138 C223.236005,82.0390776 224.457095,83.2599026 225.963386,83.2599026 Z M225.963386,41.6763737 C227.469677,41.6763737 228.690767,40.4555488 228.690767,38.949585 C228.690767,37.4436211 227.469677,36.2227962 225.963386,36.2227962 C224.457095,36.2227962 223.236005,37.4436211 223.236005,38.949585 C223.236005,40.4555488 224.457095,41.6763737 225.963386,41.6763737 Z M390.288084,113.254579 C391.794374,113.254579 393.015464,112.033754 393.015464,110.52779 C393.015464,109.021826 391.794374,107.801002 390.288084,107.801002 C388.781793,107.801002 387.560703,109.021826 387.560703,110.52779 C387.560703,112.033754 388.781793,113.254579 390.288084,113.254579 Z M342.558918,66.8991699 C344.065209,66.8991699 345.286299,65.678345 345.286299,64.1723811 C345.286299,62.6664173 344.065209,61.4455924 342.558918,61.4455924 C341.052627,61.4455924 339.831537,62.6664173 339.831537,64.1723811 C339.831537,65.678345 341.052627,66.8991699 342.558918,66.8991699 Z M286.64761,47.1299513 C288.153901,47.1299513 289.374991,45.9091264 289.374991,44.4031625 C289.374991,42.8971987 288.153901,41.6763737 286.64761,41.6763737 C285.14132,41.6763737 283.92023,42.8971987 283.92023,44.4031625 C283.92023,45.9091264 285.14132,47.1299513 286.64761,47.1299513 Z M221.872315,16.4535776 C223.378606,16.4535776 224.599696,15.2327526 224.599696,13.7267888 C224.599696,12.2208249 223.378606,11 221.872315,11 C220.366024,11 219.144934,12.2208249 219.144934,13.7267888 C219.144934,15.2327526 220.366024,16.4535776 221.872315,16.4535776 Z"
                id="bg-points"
                stroke="#B6CCE6"
              />
            </svg>
          </div>
        </div>
        {/*  09-12-2016 */}
        <div
          id="caspian"
          className="bg-brand block py3 absolute bottom left right"
        />
      </section>
    );
  }
}

export default connect(mapStateToProps)(AuthScene);
