import {constantRouterMap} from '@/router'
import {getCards} from '@/api/login'
import Layout from '@/views/layout/Layout'

const state = {
  routes: [],
  addRoutes: []
}

const mutations = {
  SET_ROUTES: (state, routes) => {
    state.addRoutes = routes
    state.routes = constantRouterMap.concat(routes)
  }
}
const cardNames = {
  ka: '渠道报表',
  fund: '资金方报表',
  repay: '还款/绑卡报表',
  other: '其他报表',
  monitor:"监控",
  query:"查询功能"
}

const actions = {
  generateRoutes({commit}) {
    return new Promise(resolve => {
      const loadMenuData = []
      // 先查询后台并返回左侧菜单数据并把数据添加到路由
      getCards(state.token).then(response => {
        let data = response
        if (response.code !== 0) {
          console.log('数据加载异常', response)
        } else {
          data = response.data
          let accessedRoutes = constantRouterMap
          for (let k in data) {
            let card = data[k]
            if (!card) {
              continue
            }

            let meu = {
              path: '/cards/' + k,
              component: Layout,
              redirect: '/example/table',
              name: 'Example_' + k,
              meta: {title: cardNames[k], icon: k},
              children: []
            };
            for (let i = 0; i < card.length; i++) {
              let c = card[i]
              meu.children.push({
                path: '/card/' + c.type + '/' + c.uuid,
                name: 'Card' + c.uuid,
                meta: {title: c.name, icon: c.display}
              })
            }
            accessedRoutes.push(meu)
          }
          commit('SET_ROUTES', accessedRoutes)
          resolve(accessedRoutes)
        }
        // generaMenu(asyncRoutes, data)
      }).catch(error => {
        console.log(error)
      })
    })
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
