from pyplotz.pyplotz import PyplotZ
from pyplotz.pyplotz import plt



plt.rc('figure',figsize=(8,6))
font_options={
    'weight':'bold',
    'size':'14'
}
plt.rc('font',**font_options)
def draw_lineplot(df,x,y,hue='',title=''):
    '''
    :param df: dataframe
    :param x: 横坐标
    :param y: 纵坐标
    :param hue: 分类
    :param title:
    :return:fig
    '''
    pltz = PyplotZ()
    pltz.enable_chinese()
    fig = plt.figure()
    ax = fig.add_subplot(1, 1, 1)
    if hue != '':
        for type in df[hue].unique().tolist():
            # == 画图
            tmp=df[df[hue]==type]
            plt.plot(tmp[x], tmp[y], linestyle='dashed', marker='o',label=type)
    else:
        plt.plot(df[x], df[y], linestyle='dashed', marker='o')
    pltz.xticks(range(len(df[x].unique().tolist())), df[x].unique().tolist())
    pltz.xlabel(x)
    pltz.ylabel(y)
    pltz.title(title)
    pltz.legend()
    plt.grid()
    plt.show()
    return fig