import lightgbm as lgb
from sklearn.metrics import roc_auc_score
from sklearn.metrics import confusion_matrix, mean_squared_error
import numpy 
import pandas

params = {
    'task': 'train',   #用途
    'application':'binary',   #用于二分类
    'boosting_type': 'gbdt',  # 设置提升类型
    'num_boost_round':100,   #迭代次数
    'learning_rate': 0.01,  # 学习速率
    'metric': {'logloss', 'auc'},  # 评估函数
    'early_stopping_rounds':None,
#         'objective': 'regression', # 目标函数
    'max_depth':4,
    'num_leaves': 20,   # 叶子节点数   
    'feature_fraction': 0.9, # 建树的特征选择比例
    'bagging_fraction': 0.8, # 建树的样本采样比例
    'bagging_freq': 5,  # k 意味着每 k 次迭代执行bagging
    
    'verbose': 1 # <0 显示致命的, =0 显示错误 (警告), >0 显示信息
    }
'''

instructions : training lightgbm model with specified params

Parameters : 
    dataset -
    features - feature list of dataset
    target - tagert column or label list of samples

'''
def lgb_train(params,training_set,features,target):
    lgb_train = lgb.Dataset(training_set[features],training_set[target])
    

