from pyplotz.pyplotz import PyplotZ
from pyplotz.pyplotz import plt
import seaborn as sns


plt.rc('figure',figsize=(8,6))
font_options={
    'weight':'bold',
    'size':'14'
}
plt.rc('font',**font_options)


'''
双坐标轴
'''
def draw_lineplot_doubleaxes(df,x,y1,y2,y1_hue='',y2_hue='',title=''):
    '''
    :param df:
    :param x:
    :param y1:
    :param y2:
    :param y1_hue:y1 轴分类
    :param y2_hue:y2 轴分类
    :param title:
    :return:
    '''


def draw_barplot(df,x,y,hue='',title=''):
    '''
    :param df: dataframe
    :param x: 横坐标
    :param y: 纵坐标
    :param hue: 分类
    :param title:
    :return:fig
    '''
    pltz = PyplotZ()
    pltz.enable_chinese()
    fig = plt.figure()
    ax = fig.add_subplot(1, 1, 1)

    sns.set(style="whitegrid")
    fig = plt.figure(figsize=(6, 4))
    ax = fig.add_subplot(1, 1, 1)
    if hue != '':
        sns.barplot(x, y, hue=hue, data=df, ax=ax)
    else:
        sns.barplot(x, y, data=df, ax=ax)
    pltz.xticks(range(len(df[x].unique().tolist())), df[x].unique().tolist())
    pltz.xlabel(x)
    pltz.ylabel(y)
    pltz.title(title)
    pltz.legend()
    plt.grid()
    plt.show()
    return fig


def draw_lineplot(df,x,y,hue='',title=''):
    '''
    :param df: dataframe
    :param x: 横坐标
    :param y: 纵坐标
    :param hue: 分类
    :param title:
    :return:fig
    '''
    pltz = PyplotZ()
    pltz.enable_chinese()
    fig = plt.figure()
    ax = fig.add_subplot(1, 1, 1)
    if hue != '':
        for type in df[hue].unique().tolist():
            # == 画图
            tmp=df[df[hue]==type]
            plt.plot(tmp[x], tmp[y], linestyle='dashed', marker='o',label=type)
    else:
        plt.plot(df[x], df[y], linestyle='dashed', marker='o')
    pltz.xticks(range(len(df[x].unique().tolist())), df[x].unique().tolist())
    pltz.xlabel(x)
    pltz.ylabel(y)
    pltz.title(title)
    pltz.legend()
    plt.grid()
    plt.show()
    return fig