import os
from docx import Document
from docx.shared import Inches

def buildDocument(path,filename):
    if str.rfind(filename,0,3)!='doc':
        if str.rfind(filename,0,4) !='docx':
            raise ValueError('{} is not a word file'.format(filename))
    if os.path.exists(os.path.join(path,filename)):
        return Document(os.path.join(path,filename))
    return Document()
def saveDocument(document,path,filename):
    if str.rfind(filename,0,3)!='doc':
        if str.rfind(filename,0,4) !='docx':
            raise ValueError('{} is not a word file'.format(filename))
    return document.save(os.path.join(path,filename))

def insert_table(document, cols, values):
    # cols 为列名
    # values 为值，list
    table = document.add_table(rows=1, cols=len(cols),style='Medium Grid 1 Accent 1')
    hdr_cells = table.rows[0].cells
    for i in range(len(cols)):
        hdr_cells[i].text = cols[i]
    for value in values:
        row_cells = table.add_row().cells
        for i in range(len(cols)):
            row_cells[i].text = str(value[i])
    return document