import pandas as pd
import numpy as np
import datetime
from data.analyis import filetool
from data.analyis import datacal
from models import xgboost
from matplotlib import pyplot as plt
from data.graph import drawplot

def report(dftrain,dftest,features,label,path,filename):
    document=filetool.buildDocument(path,filename)
    document.add_heading('xgboost 算法运行报告')
    clf=xgboost.buildClf()
    document.add_paragraph('初始化参数运行{}'.format(clf.get_xgb_params()))
    clf=xgboost.modelfit(clf,dftrain,features,label)
    document.add_paragraph('模型训练集{}'.format(xgboost.auc(clf,dftrain,features,label)))
    document.add_paragraph('模型测试集{}'.format(xgboost.auc(clf, dftest, features, label)))

    document.add_heading('调整参数')
    max_depth=[2,3]
    min_child_weight=range(1,4,1)
    document, clf = tun_params(document, clf, dftrain, dftest, {'max_depth': max_depth,'min_child_weight':min_child_weight}, features, label)

    # gamma
    gamma=[i/10 for i in range(0,5)]
    document,clf=tun_params(document,clf,dftrain,dftest,{'gamma':gamma},features,label)

    # subsample colsample_bytree
    subsample=[0.8,0.9,1]
    colsample_bytree=[0.8,0.9,1]
    document, clf = tun_params(document, clf, dftrain, dftest,
                               {'subsample': subsample, 'colsample_bytree': colsample_bytree}, features, label)

    # reg_alpha
    reg_alpha=[0.001,0.01,0.1,1,10]
    document, clf = tun_params(document, clf, dftrain, dftest,
                               {'reg_alpha': reg_alpha}, features, label)

    # reg_lambda
    reg_lambda = [0.001, 0.01, 0.1, 1, 10]
    document, clf = tun_params(document, clf, dftrain, dftest,
                               {'reg_lambda': reg_lambda}, features, label)

    #==生成模型最后的报告，各个特征的单变量图，PDP，liftchart
    dftrain=xgboost.predict(clf,dftrain,features)
    dftest=xgboost.predict(clf,dftest,features)
    featureimp=xgboost.featureImportance(clf,features).to_frame(name=['weight','feature'])
    fig=drawplot.draw_barplot(featureimp.head(10),'feature','weight',title='Feature importance')
    fig.savefig('tmp.png')
    document.add_paragraph('特征权重图，近前10个特征')
    document.add_picture('tmp.png')

    filetool.saveDocument(document,path,filename)








def tun_params(document,clf,dftrain,dftest,params,features,label):
    for i in dict(params).keys():
        document.add_paragraph('调参{},取值{}'.format(i,params[i]))
    grid_search = xgboost.automodelfit(clf, params,dftrain, features, label)
    clf = grid_search.best_estimator_
    document.add_paragraph('模型训练参数{}'.format(clf.get_xgb_params()))
    clf = xgboost.modelfit(clf, dftrain, features, label)
    document.add_paragraph('最优参数{},最优分{}'.format(grid_search.best_params_,grid_search.best_score_))
    document.add_paragraph('模型训练集{}'.format(xgboost.auc(clf, dftrain, features, label)))
    document.add_paragraph('模型测试集{}'.format(xgboost.auc(clf, dftest, features, label)))
    return document,clf



