'''
@allocator V1.0
'''
#################################################### report settings ###################################################
from models_obj import dhb_obj
import datetime
import pandas as pd
import os
from mvp import refit
from tools import datacal

# 渠道列表
applied_from = {'1,214,217,198': '内部', '333': '融360', '159537': '360金融'}

# 申请类型列表
applied_type = {'1,2':'首贷','1,2,3':'首付贷','1':'首申','2':'复申','3':'复贷'}

# workspace 路径
worksapce = 'E:\\bla\\model_mvp\\'

# 样本路径
sample_path = 'E:\\model\\model_mvp\\mvp\\sample.csv'

# N+标签
target = 'target'

# 线上模型分字段
score = 'score'

# 预测模型分字段
prediction = 'predict'

# 报告生成路径
report_path = worksapce
# 报告名称
report_name = "lgb_report.docx"

# 切换到workspace目录下 避免相对路径不能识别问题
os.chdir(worksapce)
#################################################### training settings #################################################
# 生成电话帮对象(使用默认参数)
dhb = dhb_obj.dhb(features=None, sql=None, start_time_period=None, end_time_period=None,passdue_day=15)
# 需要对特征进行调整时，在这里直接dhb.features = 赋值即可

# 提取样本
#df_sample = dhb.dhb_features_extract()
# 这里直接使用csv读入样本
df_sample = pd.read_csv(sample_path,engine='python')

# 电话帮数据处理
# 自定义方法 / 默认数据处理方法
df_sample = dhb.dhb_features_prepocessing(df_sample)


# 备份df_sample
#df_sample.to_csv(str(datetime.date.today())+"dhb_samples.xlsx")

# 默认样本划分
df_train, df_val, df_test = datacal.train_test_split_general(df_sample, val_size=0.2, test_size=0.2, stratify=target,
                                                             random_state=7, split_methods='random',
                                                             time_label='applied_at')
del df_sample

# 模型refit
model_matrix, lgbm = refit.model_fit(df_train, df_val, df_test, dhb, target, score)

print(model_matrix)
# 生成报告
status = refit.model_report(lgbm, df_train, df_val, df_test, dhb, target, model_matrix,
                 score, prediction, report_path, report_name, applied_from, applied_type, topN=3)



























