[TOC]

# 项目介绍

- 本项目主要用于风控模型监控.
- 运用统计绘图分析, 来检测入模特征, 客群变化, 模型性能.
- 基本流程:
- 数据库取数 --> 整合/处理数据 --> 绘图 --> 统计
- 主要统计图类别:

  - VLM

  - PSI

  - Lift Chart


# 版本信息

- V 0.0.1

  基本完成对PSI和Lift Chart关于模型分在MongoDB的重写.
  
- V 0.0.2

  - 删除last_month参数, 设定运行当天的前一天为最新日期, 往前的(num_month - 1)月的1号为起始日期, 最新日期往前45天(若设定passdue_day=15)那天为有响应的最新日期.

  - 对PSI的计算, 时间跨度为(起始日期 --> 最新日期)

  - 对AUC的计算, 时间跨度为(起始日期 --> 有响应最新日期)

  - 添加对PSI和AUCR(后面月份相对基准月的AUC比率)的异常检测.

# VLM

- 待重写.

# PSI & Lift Chart

- 因为这两个指标的统计都需要用到模型分, 所以放到一起.

## 计算流程

- 首先对需要计算的模型分, 在指定的统一时间跨度内进行数据抽取(在MySQL和MongoDB中). 包括如下一些主要字段:
  - 模型分1, 模型分2, ...
  - 订单号, 申请时间, 申请类型, 渠道类型, 逾期天数.
- 根据预定义逾期阈值, 得到是否逾期标签.
- 根据该模型分有记录的第一个月, 计算分箱规则(由模型分等频分箱区间, PSI在申请集上计算, AUC在放款集上计算).
- 分别对全样本, 首申/复申/复贷, 以及各达标客群(客群数量大于预设阈值), 计算每月统计信息.
- PSI统计信息:
  - 样本量.
  - 各分箱样本量
  - 各分箱样本量占比
  - 以该客群模型分有记录的第一个月为基准的PSI.
- Lift Chart统计信息:
  - 样本量
  - 各分箱样本量
  - 各分箱逾期率
  - AUC
  - 以该客群模型分有记录的第一个月为基准的AUC ratio.
- 统计表格信息, 方便筛选排序查看, 包含以下字段:
  - 模型分名称.
  - a月样本量, b月样本量...
  - a月PSI, b月PSI...
  - a月AUC, b月AUC...
  - 某个客群是否异常(AUC明显下降, PSI较大).
- NOTE:
  - 当某月样本量很小, 或者没有样本时, 标记为NaN. 对应的PSI, AUC也为NaN.
  - 当某月样本量比较小, 导致PSI, AUC计算异常(如某些分箱没有样本, 全为非逾期样本), 则标记为-999.
  - 基准月的PSI为0.

## 使用方法

- 准备一个Excel表格, 其中放置模型分名称, 以及对应的在数据库中的字段名.

- 创建一个模型监控对象(这样我们就有对象了^v^).

  ```python
  mm = ModelMonitor(excel_path='./model_score.xlsx', save_path='./image/', num_month=4, min_user_group=500, max_psi=0.1, min_aucr=0.8)
  ```

  - excel_path: Excel文件路径.

  - save_path: 统计图存放路径.

    不用自己再另外手动创建文件夹, 代码会判断文件夹是否存在并创建.

  - num_month: 想要统计近期几个月(包含运行程序时所在的日期前一天, 如运行时为7.1, 则不包含7月数据, 如运行时为7.10, 则将7月9天算作7月数据).

  - min_user_group: 最小客群数量.

    这个参数越大, 颗粒越粗, 最后的统计图(客群数量)会越少.

    反之颗粒越小, 最后统计图会越多.
  
  - max_psi: 最大PSI, 大于则视为该客群异常.

  - min_aucr: 最小AUCR, 小于则视为该客群异常.


- 执行run函数.

  ```python
  mm.run()
  ```

- 输出:

- 图片保存在./image中.
  - PSI: ./image/PSI
  - Lift Chart: ./image/AUC
- 统计信息.
  - PSI统计信息: ./psi_info.csv
  - AUC统计信息: ./auc_info.csv

# TODO

- 添加对存在MySQL中模型分计算PSI, AUC的代码.
- 完成对VLM的重写.
- 部分(量信分, app模型)模型分报错, 进一步与模型维护者交流, 看是否字段名或者其它地方有问题.

# 贡献

- 王家华 (jiahua.wang@quantgroup.cn)

  旧代码作者.

- 舒皓月 (haoyue.shu@quantgroup.cn)

  新代码作者.