[TOC]

# 项目介绍

- 本项目主要用于风控模型监控.
- 运用统计绘图分析, 来检测入模特征, 客群变化, 模型性能.
- 基本流程, 数据库取数 --> 整合/统计 --> 绘图
- 主要统计信息: VLM, PSI, AUC


# 使用前提

- 准备一个包含需要查询模型分的excel, 包含其中文名和英文名(mongo中的字段名).
- 项目中的model_score.xlsx包含大部分在使用的模型分.

# VLM

- 使用方法

  在234服务器中, 将项目中的VLM_time.py放在自己的某一文件夹(同时包含excel表)下, 然后在notebook中操作如下.

```python
# 导入脚本
from VLM_time import *
# 创建对象
vlm_mm = VLMMonitor(excel_path='./model_score.xlsx',
                    sheet_name='model',
                    save_path='./vlm/',
                    if_read=True, if_save=True,
                    alpha=0.01, min_user_group=600,
                    start_date='2019-09-01', end_date='2019-11-01')
# 运行
vlm.run()
```

- 对象参数说明(使用时主要设置时间即可):

  - excel_path: excel路径.
  - sheet_name: excel页名称.
  - save_path: 输出保存路径.
  - if_read & if_save: if_read表示是否从数据库取数据, 若为false则从本地取数据. if_save表示是否保存数据.这两个参数主要用于debug, 默认为true即可.
  - alpha: mk-test显著性阈值.
  - min_user_group: 最小客群数量, 用于过滤特别小的客群. 一般不用调整, 默认即可.
  - start_date & end_date: 需要查询的起始和终止时间, 根据需求设定.

- 输出

  - 图片, 保存在save_path下的image中.
  - 相关统计信息, 保存在save_path下的info中

- info的一些使用方法

  - 读取info

    ![F6010A07-103A-4cdf-95A6-41848F3DE07D](image/F6010A07-103A-4cdf-95A6-41848F3DE07D.png)

  - 挑选出某个模型分的信息.

    ![66EEADB8-4133-4338-AAB0-8FE48526CBBF](image/66EEADB8-4133-4338-AAB0-8FE48526CBBF.png)

  - 挑选出均值超过三倍标准差的客群.

    ![77F951A3-088F-4af0-AF74-C6F66BC8EAE6](image/77F951A3-088F-4af0-AF74-C6F66BC8EAE6.png)

  - 挑选出有趋势的客群, 并按p值排序.

    ![D39E34EF-592A-4bfe-95D8-694B3B7BBFEC](image/D39E34EF-592A-4bfe-95D8-694B3B7BBFEC.png)

# PSI

- 使用方法

  在234服务器中, 将项目中的PSI_time.py放在自己的某一文件夹下(同时包含excel表), 然后在notebook中操作如下.

```python
# 导入脚本
from PSI_time import *
# 创建对象
psi_mm = PSIMonitor(excel_path='./model_score.xlsx', sheet_name='model',
                    min_user_group=500, max_psi=0.1, interval_days=30,
                    save_path='./psi/',
                    if_save=True, if_read=True,
                    date_list=('2019-07-01', '2019-08-01', '2019-09-01', '2019-10-01','2019-11-01'))
# 运行
psi_mm.run()
```

- 对象参数说明(使用时主要设置date_list即可):
  - excel_path: excel路径.
  - sheet_name: excel页名称.
  - save_path: 输出保存路径.
  - if_read & if_save: if_read表示是否从数据库取数据, 若为false则从本地取数据. if_save表示是否保存数据.这两个参数主要用于debug, 默认为true即可.
  - max_psi: PSI异常阈值, 超过该值则视为客群分布变化过大.
  - min_user_group: 最小客群数量, 用于过滤特别小的客群. 一般不用调整, 默认即可.
  - interval_days: 时间跨度, 与date_list对应, 默认30天.
  - date_list: 时间区间, 如这里包含4个区间(4个月), 每个区间约30天.

- 输出

  - 图片, 保存在save_path下的image中.
  - 相关统计信息, 保存在save_path下的info中

- info的一些使用方法

  - 读取info

    ![DDFBB70E-2A39-4292-94B8-9487474BFA35](image/DDFBB70E-2A39-4292-94B8-9487474BFA35.png)

  - 选取某个模型分

    ![1D7A7A0A-8B66-4f31-A5F3-F21C1FA5BADA](image/1D7A7A0A-8B66-4f31-A5F3-F21C1FA5BADA.png)

  - 挑选出PSI过大的客群.

    ![9DF6F484-6FA3-4b60-BA42-8D27A1B025AA](image/9DF6F484-6FA3-4b60-BA42-8D27A1B025AA.png)

# AUC

- 使用方法

  在234服务器中, 将项目中的AUC_time.py放在自己的某一文件夹下(同时包含excel表), 然后在notebook中操作如下.

```python
# 导入脚本
from AUC_time import *
# 创建对象
auc_mm = AUCMonitor(excel_path='./model_score.xlsx', sheet_name='model',
                    passdue_day=15, save_path='./auc/',
                    min_user_group=500, interval_days=15, min_auc=0.55,
                    date_list=('2019-07-01', '2019-07-15', '2019-08-01', '2019-08-15', '2019-09-01', '2019-09-15'),
                    if_read=True)
# 运行
auc_mm.run()
```

- 对象参数说明(使用时主要设置date_list即可):

  - excel_path: excel路径.
  - sheet_name: excel页名称.
  - save_path: 输出保存路径.
  - if_read: 表示是否从数据库取数据, 若为false则从本地取数据. 
  - passdue_day: 首逾多少天算坏样本.
  - min_auc: AUC阈值, 小于该值则表示模型分区分度低.
  - min_user_group: 最小客群数量, 用于过滤特别小的客群. 一般不用调整, 默认即可.
  - interval_days: 时间跨度, 与date_list对应, 默认15天.
  - date_list: 时间区间, 如这里包含4个区间, 每个区间约15天.

- 输出

  - 图片, 保存在save_path下的image中.
  - 相关统计信息, 保存在save_path下的info中

- info的一些使用方法

  - 读取info

    ![135AB666-12A0-486e-9314-5F61678CED1D](image/135AB666-12A0-486e-9314-5F61678CED1D.png)

  - 选择某个模型并查看其各客群AUC

    ![8EC5983E-542C-4c41-A390-817CAC0C05A3](image/8EC5983E-542C-4c41-A390-817CAC0C05A3.png)

# TODO

- 自动出简略监控报告的脚本.
- 将图片保存到pdf中.

# 版本信息

- V 0.0.1

  - 基本完成对PSI和Lift Chart关于模型分在MongoDB的重写.

- V 0.0.2

  - 删除last_month参数, 设定运行当天的前一天为最新日期, 往前的(num_month - 1)月的1号为起始日期, 最新日期往前45天(若设定passdue_day=15)那天为有响应的最新日期.
  - 对PSI的计算, 时间跨度为(起始日期 --> 最新日期)
  - 对AUC的计算, 时间跨度为(起始日期 --> 有响应最新日期)
  - 添加对PSI和AUCR(后面月份相对基准月的AUC比率)的异常检测.

- V 0.0.3

  - 增加对每个客群基准月PSI的计算, 原本默认为0, 改为客群基准月与该模型分整体第一个月之间的PSI.

    这样既可以看每个客群随时间的分布变化, 也能看到每个客群的分布与总体的差距.

  - 增加对每个客群基准月AUCR的计算, 原本默认为1, 改为客群基准月与该模型分整体第一个月之间的AUC比率.

    这样既可以看每个客群随时间AUC的变化, 也可以看到每个客群的AUC与整体的差别.

  - 增加数据读写模式的功能, 主要方便debug.
  
- V 0.0.4

  - 删除基准月AUCR, PSI的计算.
  - 重写VLM.
  - 增加过滤空跑数据的功能.
  - 增强代码鲁棒性.
  
- V 0.1.0

  - 全部数据从mongo中获取.
  - VLM, PSI, AUC分开计算.

# 贡献

- 王家华 (jiahua.wang@quantgroup.cn)

  旧代码作者.

- 舒皓月 (haoyue.shu@quantgroup.cn)

  新代码作者.