package com.quantgroup.hive.util;

import org.apache.hadoop.hive.ql.exec.UDF;

public class PhoneRelationRowKey extends UDF {
	
    public String evaluate(String phone,String receiverphone) {
    	
    	if (phone == null) {
            return null;
        }
    	
    	try {
			String reversePhone = new StringBuilder(phone).reverse().toString();
			String prefix=Integer.toHexString(Integer.parseInt(reversePhone.substring(0, 6))%16);
			return new StringBuffer(prefix).append(reversePhone).append(receiverphone).toString();
		} catch (NumberFormatException e) {
			return null;
		}
    	
    }
    
}
