package com.model;

import com.emums.ErrorType;
import lombok.Getter;

/**
 * 对外接口统一返回的对象
 * @author xiaoguang.xu
 * @date 2020-04-08
 */
@Getter
public class JsonResult<T> {
    /** 消息代码：0-成功 */
    private String code;
    /** 提示信息 */
    private String msg;
    /** 返回数据 */
    private Object data;
    /** 时间戳 */
    private Long timestamp;

    private JsonResult() {
        this.timestamp = System.currentTimeMillis();
    }

    private JsonResult(ErrorType errorType, String extendCode, String msg, Object data) {
        this();
        this.code = errorType.getFullCode(extendCode);
        this.msg = msg;
        this.data = data;
    }

    public static <T> JsonResult<T> success() {
        return buildResult(ErrorType.SUCCESS);
    }

    public static <T> JsonResult<T> success(T data) {
        return buildResult(ErrorType.SUCCESS, null, "正确", data);
    }

    public static <T> JsonResult<T> error(ErrorType errorType, String extendCode, String msg) {
        return buildResult(errorType, extendCode, msg, null);
    }

    public static <T> JsonResult<T> error(ErrorType errorType, String extendCode, String msg, T data) {
        return buildResult(errorType, extendCode, msg, data);
    }

    public static <T> JsonResult<T> unknownError() {
        return buildResult(ErrorType.UNKNOWN);
    }

    private static <T> JsonResult<T> buildResult(ErrorType errorType) {
        return new JsonResult<T>(errorType, "", errorType.getDesc(), null);
    }

    private static <T> JsonResult<T> buildResult(ErrorType errorType, String extendCode, String msg, T data) {
        return new JsonResult<T>(errorType, extendCode, msg, data);
    }
}
