package com.entity.jpa;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/23 14:53
 * @description：
 * @modified By：
 * @version:
 */
@MappedSuperclass
@Data
public class BaseRepositoryEntry implements Serializable {

    private static final long serialVersionUID = 6428836373638907908L;

    @Column(name = "create_at")
    private Timestamp createdAt;
    @Column(name = "update_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }


}
