package com.emums;

import com.google.common.base.Strings;

/**
 * 定义错误类别，全局唯一
 *
 * @author xiaoguang.xu
 * @date 2020-04-08
 */
public enum ErrorType {
    /**
     * 正确。
     */
    SUCCESS("0", "正确") {
        @Override
        public String getFullCode(String extendCode) {
            return this.getCode();
        }
    },
    /**
     * 客户端错误，代表着客户端错误，一般情况下由客户端自行解决
     */
    AUTH("401", "权限错误"),
    RATE_LIMIT("402", "流量控制"),
    PARAM("403", "参数错误"),
    URI("404", "请求地址错误"),
    CONCURRENT("405", "并发错误"),
    BEHAVE("406", "行为错误"),
    /**
     * 服务端错误
     */
    MIDDLEWARE("501", "中间件错误"),
    THIRD_PART("502", "第三方服务错误"),
    FAIL("503", "未保存"),
    /**
     * 不可预知的错误，一般不会出现，出现时必须处理，包装成客户端错误或服务端错误
     */
    UNKNOWN("600", "未知错误");

    private final String code;
    private final String desc;

    protected String getCode(){
        return this.code;
    }

    ErrorType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getFullCode(String extendCode) {
        return this.code + Strings.padStart(extendCode, 2, '0');
    }

    public String getDesc() {
        return desc;
    }
}
