package com.config;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

// 配置参数
@Configuration
@Getter
public class ReportConfig {
    //删除文件名字
    @Value("${delinfoFileName}")
    private String delinfoFileName;
    //业务文件名字
    @Value("${businfoFileName}")
    private String businfoFileName;
    //临时文件的位置
    @Value("${filePathPre}")
    private String filePathPre;
    //是否脱敏
    @Value("${isDesensitization}")
    private boolean isDesensitization;
    //组织机构代码
    @Value("${organizationCode}")
    private String organizationCode;
    //统一社会信用代码
    @Value("${uniformSocialCreditCode}")
    private String uniformSocialCreditCode;
    //9位代码 (组织机构代码或者是统一社会信用代码的9-17)咱们系统中统一使用9位的组织机构代码
    @Value("${code}")
    private String code;
    /* 接口key
     * 由协会在开通接口时发放，联调环境与生产环境采用不同的key
     * 十分重要，生产参数务必保存好
     */
    @Value("${interFaceKey}")
    private String interFaceKey;
    //[数据共享查询]
    @Value("${infoUrl}")
    private String infoUrl;
    //司法数据查询
    @Value("${infoPeopleUrl}")
    private String infoPeopleUrl;
    //耗用查询量查询
    @Value("${infoQueryContralUrl}")
    private String infoQueryContralUrl;

    // [报送接口]
    @Value("${dataUri}")
    private String dataUri;
    // [报送状态查看接口]
    @Value("${taskUri}")
    private String taskUri;
    // 报送文件加密用公钥1 测试阶段无需修改，生产接入时另行发放
    @Value("${xPubkey}")
    private String xPubkey;
    // 报送文件加密用公钥2 测试阶段无需修改，生产接入时另行发放
    @Value("${yPubKey}")
    private String yPubKey;
    // 反馈文件解密用私钥 测试阶段无需修改，生产接入时另行发放
    @Value("${prvKey}")
    private String prvKey;
    //运行定时器的IP
    @Value("${timerIp}")
    private String timerIp;

}
