package com.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/10/30 18:37
 * @description：时间工具类
 * @modified By：
 * @version: 1.0
 */
public class DateUtil {

    public final static String YYYY_MM_DD_MM_HH_SS = "yyyy-MM-dd HH:mm:ss";

    public final static String YYYY_MM_DD = "yyyy-MM-dd";

    public final static String YYYYMMDDMMHHSSSSS = "yyyyMMddHHmmssSSS";

    public final static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public final static String YYYYMMDDHHMM = "yyyyMMddHHmm";

    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";

    public static String getCurrentDay(int day) {
        return getCurrentDay(day, YYYY_MM_DD_MM_HH_SS);
    }

    public static String getCurrentDay(int day, String pattner) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, day);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return new SimpleDateFormat(pattner).format(calendar.getTime());
    }

    public static String getCurrentDay(String date, int day) {
        return getCurrentDay(date, day, YYYY_MM_DD_MM_HH_SS, YYYY_MM_DD_MM_HH_SS);
    }

    public static String getCurrentDay(String date, int day, String inPartner, String outPartner) {
        Date time = null;
        try {
            time = new SimpleDateFormat(inPartner).parse(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(Calendar.DAY_OF_MONTH, day);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return new SimpleDateFormat(outPartner).format(calendar.getTime());
    }

    /**
     *
     * @param date 时间
     * @param month 月份
     * @param inPartner 入参时间格式
     * @param outPartner 出参时间格式
     * @return
     */
    public static String getCurrentMonth(String date, int month, String inPartner, String outPartner) {
        Date time = null;
        try {
            time = new SimpleDateFormat(inPartner).parse(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(Calendar.MONTH, month);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return new SimpleDateFormat(outPartner).format(calendar.getTime());
    }


    /**
     * 获取当月月初日期
     *
     * @param currentDate 当前日期
     * @param pattern     日期格式
     * @return
     * @throws ParseException
     */
    public static String getCurrentMonthFirstDay(String currentDate, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date date = simpleDateFormat.parse(currentDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, 0);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return simpleDateFormat.format(calendar.getTime());
    }

    /**
     * 获取当前服务器时间
     *
     * @param format 日期格式化,例如yyyy-MM-dd
     * @return
     */
    public static String getCurrentServerDate(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(Calendar.getInstance().getTime());
    }

    /**
     * 获取当月月初日期
     *
     * @param currentDate 当前日期(格式为 yyyy-MM-dd)
     * @return
     * @throws ParseException
     */
    public static String getCurrentMonthFirstDay(String currentDate) throws ParseException {
        return getCurrentMonthFirstDay(currentDate, YYYY_MM_DD);
    }

    public static String formatterDate(Object date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        if (date instanceof Date) {
            return dateFormat.format(date);
        } else {
            return date.toString();
        }
    }

    public static String formatterDate(String date, String oldPattern, String newPattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(oldPattern);
        try {
            SimpleDateFormat dateFormatNew = new SimpleDateFormat(newPattern);
            return dateFormatNew.format(dateFormat.parse(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static LocalDate dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone).toLocalDate();
    }

    public  static Date getDate(Date date,String pattern){
        SimpleDateFormat dateFormatNew = new SimpleDateFormat(pattern);
        try {
            return dateFormatNew.parse(dateFormatNew.format(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
}
