package com.timer;

import cn.quantgroup.tech.elastic.job.lite.annotation.ElasticSimpleJob;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.service.statistics.QueryStatisticsService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/24 15:42
 * @description：统计定时器
 * @modified By：
 * @version: 1.0
 *每天凌晨泡一下
 */

@Component
@ElasticSimpleJob(cron = "0  1  0  *  * ?", jobName = "QueryStatisticsTimer")
public class QueryStatisticsTimer implements SimpleJob {

    @Resource
    private QueryStatisticsService queryStatisticsService;


    @Override
    public void execute(ShardingContext shardingContext) {
        Calendar calendar = Calendar.getInstance();

        calendar.add(Calendar.DATE, -1);

        queryStatisticsService.doStatisticsSave(calendar.getTime());
    }
}
