package com.service.statistics.impl;

import com.emums.Corporation;
import com.emums.DataSource;
import com.entity.jpa.QueryStatisticsEntry;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.jpa.repository.QueryStatisticsRepository;
import com.model.QueryStatisticsModel;
import com.service.statistics.GetReportAndSearchNum;
import com.service.statistics.QueryStatisticsService;
import com.util.ApplicationContextHelper;
import com.util.DateUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;


import javax.annotation.Resource;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/23 16:51
 * @description：服务实现
 * @modified By：
 * @version:
 */
@Service
public class QueryStatisticsServiceImpl implements QueryStatisticsService {

    @Resource
    private QueryStatisticsRepository queryStatisticsRepository;

    @Resource
    private ApplicationContextHelper applicationContextHelper;


    @Override
    public List<QueryStatisticsModel> query(Timestamp start, Timestamp end) {

        List<QueryStatisticsModel> result = Lists.newArrayList();

        List<QueryStatisticsEntry> datas = queryStatisticsRepository.findByReportTimeAfterAndReportTimeBefore(start, end);

        Map<String, List<QueryStatisticsEntry>> collect = datas.stream().collect(Collectors.groupingBy(this::groupByKey));

        collect.forEach((k, v) -> result.add(convertQueryStatisticsModel(k, v)));

        return result;
    }

    @Override
    public void statisticsAndSave(List<QueryStatisticsEntry> list) {

        list.stream().forEach(queryStatisticsRepository::save);
    }

    @Override
    public void doStatisticsSave(Date time) {


        ApplicationContext context = applicationContextHelper.getInstance();
        Map<String, GetReportAndSearchNum> beansOfType = context.getBeansOfType(GetReportAndSearchNum.class);


        beansOfType.forEach((k, v) -> {
            List<QueryStatisticsEntry> byDate = v.getByDate(time);
            //查询本日有没有
            List<QueryStatisticsEntry> byReportTime = queryStatisticsRepository
                    .findByReportTimeAndDataSource(new Timestamp(DateUtil.getDate(time,DateUtil.YYYY_MM_DD).getTime()), v.getDataSource());

            byDate.stream().forEach(o -> {

                byReportTime.forEach(q -> {
                    if (o.getCorporation() == q.getCorporation()) {
                        o.setId(q.getId());
                        o.setCreatedAt(q.getCreatedAt());
                        o.setUpdatedAt(q.getUpdatedAt());
                    }
                });

                o.setDataSource(v.getDataSource());
                o.setReportMonth(DateUtil.formatterDate(time, DateUtil.YYYY_MM));
                o.setReportTime(new Timestamp(DateUtil.getDate(time, DateUtil.YYYY_MM_DD).getTime()));
            });
            //保存
            statisticsAndSave(byDate);
        });

    }

    /**
     * 数据转换
      * @param key
     * @param list
     * @return
     */
    private QueryStatisticsModel convertQueryStatisticsModel(String key, List<QueryStatisticsEntry> list) {
        QueryStatisticsModel model = new QueryStatisticsModel();
        List<String> split = Splitter.on("#").splitToList(key);
        String reportMonth = split.get(0);
        String dataSource = split.get(1);
        String corporation = split.get(2);
        //已经查询总量
        long sum = list.stream().mapToLong(QueryStatisticsEntry::getQueryQuantity).sum();
        Long maxQueryNum = list.stream().findAny().get().getMaxQueryNum();
        model.setTime(reportMonth);
        model.setDataSource(DataSource.valueOf(dataSource));
        model.setCorporation(Corporation.valueOf(corporation));
        model.setHasQueryNum(sum);
        model.setMaxQueryNum(maxQueryNum);
        model.setCanQueryNum(maxQueryNum - sum);
        return model;
    }

    /**
     * 按照月份数据源主体分组
     *
     * @param q
     * @return
     */
    private String groupByKey(QueryStatisticsEntry q) {
        return String.format("%s#%s#%s", q.getReportMonth(),
                q.getDataSource().name(), q.getCorporation().name());
    }

}
