package com.service.statistics.impl;

import com.emums.Corporation;
import com.emums.DataSource;
import com.entity.jpa.QueryStatisticsEntry;
import com.google.common.collect.Lists;
import com.jpa.repository.QueryStatisticsRepository;
import com.mapper.report.BaiHangMapper;
import com.service.statistics.GetReportAndSearchNum;
import com.util.DateUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/24 10:37
 * @description：百行获取上报查询数量
 * @modified By：
 * @version: 1.0
 */
@Service
public class BaiHangReportAndSearchNum implements GetReportAndSearchNum {

    @Resource
    private BaiHangMapper baiHangMapper;

    @Resource
    private QueryStatisticsRepository queryStatisticsRepository;

    @Override
    public DataSource getDataSource() {
        return DataSource.BAIHANG;
    }


    @Override
    public List<QueryStatisticsEntry> getByDate(Date date) {

        Date start = DateUtil.getDate(date, DateUtil.YYYY_MM_DD);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        //增加一天
        calendar.add(Calendar.DATE, 1);
        //广达上报数量
        long gdXdReportNum = baiHangMapper.getGdXdReportNum(start, calendar.getTime());
        //众信利民上报数
        long zxLmReportNum = baiHangMapper.getZxLmReportNum(start, calendar.getTime());
        //众信利民查询数
        long zxLmSearchNum = baiHangMapper.getZxLmSearchNum(start, calendar.getTime());
        //广大小贷查询数
        long gdXdSearchNum = baiHangMapper.getGdXdSearchNum(start, calendar.getTime());

        QueryStatisticsEntry zxlm = new QueryStatisticsEntry();

        zxlm.setCorporation(Corporation.ZHONGXINLIMIN);
        zxlm.setQueryQuantity(zxLmSearchNum);
        zxlm.setReportNum(zxLmReportNum);
        zxlm.setMaxQueryNum(0L);

        QueryStatisticsEntry gdxd = new QueryStatisticsEntry();

        gdxd.setCorporation(Corporation.GUANGDAXIAODAI);
        gdxd.setQueryQuantity(gdXdSearchNum);
        gdxd.setReportNum(gdXdReportNum);
        gdxd.setMaxQueryNum(0L);
        //本月
        Date month = DateUtil.getDate(date, DateUtil.YYYY_MM);

        calendar.setTime(month);
        calendar.add(Calendar.MONTH,-1);

        //上月co
        String preMonth = DateUtil.formatterDate(calendar.getTime(), DateUtil.YYYY_MM);

        List<QueryStatisticsEntry> byReportMonth = queryStatisticsRepository
                .findByReportMonthAndDataSource(preMonth, getDataSource());

        Map<Corporation, List<QueryStatisticsEntry>> groupByCorp = byReportMonth
                .stream()
                .collect(Collectors.groupingBy(QueryStatisticsEntry::getCorporation));

        //最大查询量为上月报送量*10
        groupByCorp.forEach((k,v)->{

            long sum = v.stream()
                    .mapToLong(QueryStatisticsEntry::getReportNum)
                    .sum();

            if(k == Corporation.GUANGDAXIAODAI){
                gdxd.setMaxQueryNum(sum * 10);
            }

            if(k == Corporation.ZHONGXINLIMIN){
                zxlm.setMaxQueryNum(sum * 10);
            }
        });

        return Lists.newArrayList(zxlm, gdxd);
    }


}
