package com.jpa.repository;

import com.emums.DataSource;
import com.entity.jpa.QueryStatisticsEntry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.sql.Timestamp;
import java.util.List;

public interface QueryStatisticsRepository extends JpaRepository<QueryStatisticsEntry, Long>, JpaSpecificationExecutor<QueryStatisticsEntry> {
    List<QueryStatisticsEntry> findByReportTimeAfterAndReportTimeBefore(Timestamp start, Timestamp end);

    List<QueryStatisticsEntry> findByReportTimeAndDataSource(Timestamp time, DataSource dataSource);

    List<QueryStatisticsEntry> findByReportMonthAndDataSource(String month, DataSource dataSource);
}
