package com.controller;

import com.emums.Corporation;
import com.emums.DataSource;
import com.model.JsonResult;
import com.model.QueryStatisticsModel;
import com.service.statistics.QueryStatisticsService;
import com.util.ThreadPoolUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/23 19:09
 * @description：
 * @modified By：
 * @version:
 */
@Slf4j
@RequestMapping("/statistics")
@RestController
public class QueryStatisticsController {

    @Resource
    private QueryStatisticsService queryStatisticsService;

    @RequestMapping("/query")
    @Validated
    public JsonResult query(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull Date start,
                            @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull Date end,
                            DataSource source, Corporation corporation) {

        log.info("查询统计,开始时间:{},结束时间:{},DataSource:{},corporation:{} ", start, end, source, corporation);
        List<QueryStatisticsModel> query = queryStatisticsService.query(new Timestamp(start.getTime()), new Timestamp(end.getTime()));
        if (null != source) {
            query = query.stream().filter(o -> o.getDataSource() == source).collect(Collectors.toList());
        }
        if (null != corporation) {
            query = query.stream().filter(o -> o.getCorporation() == corporation).collect(Collectors.toList());
        }
        log.info("查询统计结束,开始时间:{},结束时间:{},DataSource:{},corporation:{},result:{} ", start, end, source, corporation, query);

        return JsonResult.success(query);
    }

    @RequestMapping("/runData")
    public JsonResult runData(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull final Date start,
                              @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull final Date end) {

        ExecutorService requstInstance = ThreadPoolUtil.getRequstInstance();
        requstInstance.execute(() -> {
            Date startTh = start;

            Calendar calendar = Calendar.getInstance();
            while (true) {
                calendar.setTime(startTh);
                if (end.before(startTh)) {
                    break;
                }
                log.info("跑数据开始，时间：{} ", startTh);
                queryStatisticsService.doStatisticsSave(startTh);
                calendar.add(Calendar.DATE, 1);
                startTh = calendar.getTime();
            }
            log.info("跑数据完成，开始时间{},结束时间:{}", start, end);
        });
        return JsonResult.success("任务开始执行");
    }
}
