package com.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/10/29 19:44
 * @description：数据源配置
 * @modified By：
 * @version: 1.0
 */
@Configuration
@MapperScan(basePackages = "com.mapper.data", sqlSessionFactoryRef = "dataSqlSessionFactory")
public class DataDataSourceConfig {

    @Value("${db.driver}")
    private String dataDriverClass;
    @Value("${data.db.minPoolSize}")
    private int dataMinPoolSize;
    @Value("${data.db.maxPoolSize}")
    private int dataMaxPoolSize;
    @Value("${data.source.data.jdbcUrl}")
    private String dataJdbcUrl;
    @Value("${data.source.data.username}")
    private String dataUsername;
    @Value("${data.source.data.password}")
    private String dataPassword;
    @Value("${mapper.data.location}")
    private String dataMapperLocations;
    @Value("${config-location}")
    private String mapperConfig;

    @Bean(name = "dataDataSource")
    public DataSource dataDatasource() {
        HikariConfig dataconfig = new HikariConfig();
        dataconfig.setJdbcUrl(dataJdbcUrl);
        dataconfig.setUsername(dataUsername);
        dataconfig.setPassword(dataPassword);
        dataconfig.setMinimumIdle(dataMinPoolSize);
        dataconfig.setMaximumPoolSize(dataMaxPoolSize);
        return new HikariDataSource(dataconfig);
    }

    @Bean
    public DataSourceTransactionManager reporDatasourceTransactionManager(@Qualifier("dataDataSource") DataSource datasource) {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean(name = "dataSqlSessionFactory")
    public SqlSessionFactory dataSqlSessionFactory(@Qualifier("dataDataSource") DataSource dataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(dataMapperLocations));
//        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
                .getResource(mapperConfig));
        return sessionFactory.getObject();
    }
}
