package com.service.report;

import com.QgException;
import com.emums.BusinessType;
import com.emums.InfoType;
import com.entity.FileEntry;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.List;
import java.util.Map;

public interface ReportService {
    FileEntry creatZipFile(List<Map<String,Object>> dataList, InfoType infoType, BusinessType businessType) throws QgException;

    FileEntry creatZipFile(String date,List<Map<String,Object>> dataList, InfoType infoType, BusinessType businessType) throws QgException;

    FileEntry creatZipFileByString(List<String> dataList, InfoType infoType, BusinessType businessType,int index) throws QgException;

    void creatTxtFile(String filePath,List<Map<String,Object>> dataList, InfoType infoType, BusinessType businessType,boolean isDesensitization) throws QgException;

    List<Map<String,Object>> getDataAsync(Map<String,String> param);

    FileEntry creatZipFileByFile(MultipartFile file , InfoType infoType, BusinessType businessType) throws QgException;

    void reportData(FileEntry fileEntry) throws QgException;

    void quaryReportedStatus();

    void quaryReportedStatus(FileEntry fileEntry) throws QgException;

    //上报日放款数据
    void reportLoanDayData();
    //上报日还款数据
    void reportRepayDayData();
    //上报日逾期数据
    void reportOverDayData();
    //上报月逾期数据
    void reportOverMonthData();

    void runData(String date);

    void runMonthData(String date);

    void autoReReport(String path);

    void insertReportLog(String filePath);

    void insertReportLogAsync(List<Map<String, Object>> list,FileEntry fileEntry,String type);

    void insertLog();
}
