package com.controller;

import com.QgException;
import com.alibaba.fastjson.JSONArray;
import com.emums.BusinessType;
import com.emums.InfoType;
import com.entity.FileEntry;
import com.service.report.ReportService;
import com.timer.ReportTimer;
import com.util.ThreadPoolUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/11/4 15:30
 * @description：数据上报控制器
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("report")
public class ReportController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportTimer reportTimer;
    public static boolean isrun = false;

    @RequestMapping("insertLog")
    public  String insertLog(String token) {
        if (!"4745589d-f394-9028-26e5-2913aa252917".equals(token)) {
            return "token有误";
        }
        reportService.insertLog();
        return "任务开始执行";
    }

    @RequestMapping("report")
    public  String report(String token,String type) {
        if (!"4745589d-f394-9028-26e5-2913aa252917".equals(token)) {
            return "token有误";
        }
        ThreadPoolUtil.getInstance().execute(()->{
            if ("1".equals(type)) {
                reportService.reportLoanDayData();//放款
            } else if ("2".equals(type)) {
                reportService.reportRepayDayData();//还款
            } else if ("3".equals(type)) {
                reportService.reportOverDayData();//天逾期
            } else if ("4".equals(type)) {
                reportService.reportOverMonthData();//月逾期
            } else if ("all".equals(type)) {
                reportTimer.reportDayData();
            }
            reportTimer.talk(ReportTimer.result);
        });
        return "任务执行执行";
    }

    @RequestMapping("/upDataByJson")
    public Map<String, Object> upDataByJson(String json, String type) {
        Map<String, Object> result = new HashMap<>();
        List<Map<String, Object>> maps = (List<Map<String, Object>>) JSONArray.parse(json);
        BusinessType[] values = BusinessType.values();
        BusinessType btype = null;
        for (BusinessType value : values) {
            if (value.getCode().equals(type)) {
                btype = value;
                break;
            }
        }
        try {
            FileEntry fileEntry = reportService.creatZipFile(maps, InfoType.CREDIT_FINANCING_INFO, btype);
            reportService.reportData(fileEntry);
        } catch (QgException e) {
            log.error("数据上报失败： {} ,e: {}", e.alarm, e);
            result.put("msg", "上报失败，" + e.alarm);
            return result;
        } catch (Exception e) {
            log.error("数据上报失败,系统异常 ", e);
            result.put("msg", "上报失败，系统异常");
            return result;
        }
        result.put("msg", "上报成功");
        return result;
    }

    @RequestMapping("/dowloadFile")
    public void dowloadFile(String filePath, HttpServletResponse response) throws Exception {

        File file = new File(getPath(filePath));
        if (!file.exists()) {
            throw new Exception("文件不存在");
        }
        FileInputStream in = null;
        ServletOutputStream outputStream = null;
        try {
            String fileName = new String(file.getName().getBytes("gbk"), "iso-8859-1");
            // 设置response的编码方式
            response.setContentType("application/x-msdownload");
            // 设置附加文件名
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);

            in = new FileInputStream(file);
            outputStream = response.getOutputStream();
            byte[] bytes = new byte[512];
            int len = 0;
            while ((len = in.read(bytes)) != -1) {
                outputStream.write(bytes, 0, len);
            }
            outputStream.flush();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (Exception e) {
                log.error("下载文件出错，e: {} ", e);
            }

        }
    }

    @RequestMapping("/quaryReportedStatus")
    public Map<String, Object> searchMap(FileEntry fileEntry) {
        fileEntry.setFilePath(getPath(fileEntry.getFilePath()));
        Map<String, Object> result = new HashMap<>();
        try {
            reportService.quaryReportedStatus(fileEntry);
        } catch (QgException e) {
            log.error("查询上报状态失败，e: {} ", e);
            result.put("msg", e.alarm + e.message);
            return result;
        } catch (Exception e) {
            log.error("查询上报状态异常，e: {} ", e);
            result.put("msg", "查询上报状态异常");
            return result;
        }
        result.put("msg", "查询成功");
        return result;
    }

    @RequestMapping("/upDataByFile")
    public Map<String, Object> upDataByFile(@RequestParam("file") MultipartFile file, String type, String fileType) {
        Map<String, Object> result = new HashMap<>();
        BusinessType[] values = BusinessType.values();
        BusinessType btype = null;
        for (BusinessType value : values) {
            if (value.getCode().equals(type)) {
                btype = value;
                break;
            }
        }
        InfoType infotype = null;
        if (fileType == null) {
            infotype = InfoType.CREDIT_FINANCING_INFO;
        } else {
            infotype = InfoType.DELETE_INFO;
        }
        try {
            FileEntry fileEntry = reportService.creatZipFileByFile(file, infotype, btype);
            reportService.reportData(fileEntry);
        } catch (QgException e) {
            log.error("数据上报失败： {} ,e: {}", e.alarm, e);
            result.put("msg", "上报失败，" + e.alarm + e.message);
            return result;
        } catch (Exception e) {
            log.error("数据上报失败,系统异常 ,e: {}", e);
            result.put("msg", "上报失败，系统异常");
            return result;
        }
        result.put("msg", "上报成功");
        return result;
    }

    @RequestMapping("/upDataByZipFile")
    public Map<String, Object> upDataByZipFile(FileEntry fileEntry) {
        fileEntry.setFilePath(getPath(fileEntry.getFilePath()));
        Map<String, Object> result = new HashMap<>();
        try {
            reportService.reportData(fileEntry);
        } catch (QgException e) {
            log.error("数据上报失败： {} ,e: {}", e.alarm, e);
            result.put("msg", "上报失败，" + e.alarm + e.message);
            return result;
        } catch (Exception e) {
            log.error("数据上报失败,系统异常 ,e: {}", e);
            result.put("msg", "上报失败，系统异常");
            return result;
        }
        result.put("msg", "上报成功");
        return result;
    }

    //    @RequestMapping("/runData")
    public String runData(String date, String type) {
        if (isrun) {
            return "程序正在奔跑";
        }
        if (type.equals("1")) {
            reportService.runData(date);
        } else {
            reportService.runMonthData(date);

        }
        return "已经开始跑数据";
    }

    public String getPath(String old) {
        String[] split = old.split("-");
        StringBuffer sb = new StringBuffer();
        for (String str : split) {
            sb.append(str).append(File.separator);
        }
        return sb.substring(0, sb.length() - 1);
    }
}

