package com.entity.jpa;

import com.emums.Corporation;
import com.emums.DataSource;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.LocalDate;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/23 14:56
 * @description：统计实体
 * @modified By：
 * @version:
 */
@Entity
@Table(name = "query_statistics")
@Data
public class QueryStatisticsEntry  extends BaseRepositoryEntry{
    private static final long serialVersionUID = 8524346940155462970L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Long  id;

    /**
     * 上报数量
     */
    @Column(name = "report_num")
    private Long reportNum;

    /**
     * 上报时间精确到天
     */
    @Column(name = "report_time")
    private Timestamp reportTime;

    /**
     * 上报月份
     */
    @Column(name = "report_month")
    private String reportMonth;

    /**
     * 月查可查询量
     */
    @Column(name = "query_quantity")
    private Long queryQuantity;    /**
     * 月查可查询量
     */
    @Column(name = "max_query_num")
    private Long maxQueryNum;

    /**
     *数据源（0，中互金，1百行）
     */
    @Column(name = "data_suorce")
    private DataSource dataSource;
    /**
     * 报送主体
     */
    @Column(name = "corporation")
    private Corporation corporation;

}
