package com.util;

import com.QgException;
import com.cfcc.jaf.crypto.CryptoUtil;
import com.cfcc.jaf.crypto.sm.SMUtil;
import com.config.ReportConfig;
import com.service.report.impl.IReportServiceImpl;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.math.ec.ECPoint;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.applet.Main;

import java.io.*;
import java.math.BigDecimal;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;
import java.util.Map.Entry;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;


public class Utils {

    private ReportConfig reportConfig;

    public Utils(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    /**
     * 获取指定长度的随机数
     *
     * @param length
     * @return
     */

    public String getRandomNumber(int length) {
        String result = "";
        Random rnd = new Random();
        for (int i = 0; i < length; i++) {
            result += rnd.nextInt(10);
        }
        return result;
    }

    /**
     * sha256摘要算法
     *
     * @param string
     * @return
     */
    public String sha256(String string) {
        String result = null;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(string.getBytes("UTF-8"));
            byte b[] = sha.digest();
            int i;
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                String temp = Integer.toHexString(i & 0xFF);
                if (temp.length() == 1) {
                    buf.append("0");
                }
                buf.append(temp);
            }
            result = buf.toString();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 字符串转md5
     *
     * @param
     * @return
     */
    public String string2Md5(String string) {
        {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(string.getBytes("UTF-8"));
                byte[] encryption = md5.digest();

                StringBuffer strBuf = new StringBuffer();
                for (int i = 0; i < encryption.length; i++) {
                    if (Integer.toHexString(0xff & encryption[i]).length() == 1) {
                        strBuf.append("0").append(Integer.toHexString(0xff & encryption[i]));
                    } else {
                        strBuf.append(Integer.toHexString(0xff & encryption[i]));
                    }
                }

                return strBuf.toString();
            } catch (NoSuchAlgorithmException e) {
                return "";
            } catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    }

    /**
     * map to json
     *
     * @param map
     * @return
     */
    public JSONObject map2Json(Map<String, String> map) {
        JSONObject json = null;
        try {
            json = new JSONObject();
            // https://www.cnblogs.com/imzhj/p/5981665.html
            for (Entry<String, String> entry : map.entrySet()) {
                json.put(entry.getKey(), entry.getValue());
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    /**
     * 国密加密 zip转enc
     *
     * @param sourceFile
     * @param newFile
     * @return
     */
    public File encryptFile(String sourceFile, String newFile) {
        File file2 = null;
        try {
            byte[] pubx = CryptoUtil.toByteArray(reportConfig.getXPubkey());
            // 公钥2
            byte[] puby = CryptoUtil.toByteArray(reportConfig.getYPubKey());
            ECPoint pubKey = SMUtil.createECPoint(pubx, puby);
            //需要加密文件
            File file = new File(sourceFile);
            //把文件变成直接数组
            byte[] b = readFile(file);
            //加密 返回密文数组
            byte[] b2 = SMUtil.encryptBySM2(pubKey, b);
            //加密写成.enc文件
            file2 = new File(newFile);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            CryptoUtil.writeFile(b2, file2);
        } catch (Exception e) {
            e.printStackTrace();
            throw new QgException("zip转enc失败", e);
        } finally {
            System.gc();
        }
        return file2;
    }

    public static byte[] readFile(File f) throws IOException {
        RandomAccessFile r = new RandomAccessFile(f, "r");
        FileChannel fc = (r).getChannel();
        byte[] var4;
        try {
            MappedByteBuffer bytebuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size()).load();
            byte[] result = new byte[(int) fc.size()];
            if (bytebuffer.remaining() > 0) {
                bytebuffer.get(result, 0, bytebuffer.remaining());
            }

            var4 = result;
            System.gc();
        } catch (IOException var8) {
            throw var8;
        } finally {
            fc.close();
            r.close();
            System.gc();
        }
        return var4;
    }

    /**
     * 国密解密 env转zip
     *
     * @param sourceFile
     * @param newFile
     * @return
     */
    public File deccryptFile(String sourceFile, String newFile) {//解密
        File file3 = null;
        File file4 = null;
        try {
            byte[] prvKey = CryptoUtil.toByteArray(reportConfig.getPrvKey());
            //加密写成.enc文件
            file4 = new File(sourceFile);
            //读取需要解密文件
            byte[] prb = CryptoUtil.readFile(file4);
            //解密 返回明文数组
            byte[] prb2 = SMUtil.decryptBySM2(prvKey, prb);
            file3 = new File(newFile);
            if (!file3.getParentFile().exists()) {
//            	boolean mkdirs = file3.getParentFile().mkdirs();
                file3.getParentFile().mkdirs();
            }
            if (!file3.exists()) {
//				boolean createNewFile = file3.createNewFile();
                file3.createNewFile();
            }
            //解密写成.zip文件
            CryptoUtil.writeFile(prb2, file3);
        } catch (Exception e) {
            e.printStackTrace();
            throw new QgException("国密解密 env转zip异常", e);
        } finally {
            //释放占用的文件
            System.gc();
        }
        return file3;
    }

    /**
     * 读取file 转为base64字符串
     *
     * @param file
     * @return
     */
    public String file2Base64String(File file) {
        String encodeBase64String = null;
        try {
            FileInputStream instream = new FileInputStream(file);
            byte[] buffer = new byte[(int) file.length()];
            instream.read(buffer);
            instream.close();
            encodeBase64String = Base64.encodeBase64String(buffer);
        } catch (IOException e) {
            e.printStackTrace();
            throw new QgException("读取file 转为base64字符串异常", e);
        }
        return encodeBase64String;
    }

    /**
     * 将身份证的小写转为大写
     *
     * @param idCardNo
     * @return
     */
    public String manageIdCard(String idCardNo) {
        if (idCardNo.contains("x")) {
            return idCardNo.replace("x", "X");
        }
        return idCardNo;
    }

    public int random(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    public String getInt(Object val) {
        return new BigDecimal(String.valueOf(val)).setScale(0, BigDecimal.ROUND_HALF_UP).toString();
    }

    public static String getStr(String str, int indx) {
        String[] split = str.split(",", 0);
        return split[indx];
    }

    public static String getStr(String str) {
        return getStr(str, 4);
    }

    public static Collection<String> getData(File file, Collection<String> list) {
        if (file.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                // 防止路径乱码   如果utf-8 乱码  改GBK     eclipse里创建的txt  用UTF-8，在电脑上自己创建的txt  用GBK
                InputStreamReader isr = null;
                isr = new InputStreamReader(fis, "GBK");
                BufferedReader br = new BufferedReader(isr);
                String line = "";
                while ((line = br.readLine()) != null) {
                    list.add(getStr(line));
//                    list.add(line);
                }
                br.close();
                isr.close();
                fis.close();
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else {
            for (File file1 : file.listFiles()) {
                getData(file1, list);
            }

        }
        return list;
    }

    /**
     * 分割list
     *
     * @param data
     * @param size
     * @param <T>
     * @return
     */
    public <T> List<List<T>> subList(List<T> data, int size, String type,String filename) {
        List<List<T>> result = new ArrayList<>();
        int allSize = data.size();

        int count = allSize % size == 0 ? (allSize / size) : (allSize / size) + 1;
        for (int i = 0; i < count; i++) {
            List<T> item = new ArrayList<>();
            for (int j = i * size; (j < (i + 1) * size && j < allSize); j++) {
                T t = data.get(j);
                if (t instanceof Map) {
                    if(!StringUtils.isEmpty(type)){
                        ((Map<String, Object>) t).put("type", type);
                    }
                    if(!StringUtils.isEmpty(filename)){
                        ((Map<String, Object>) t).put("filename", filename);
                    }
                }
                item.add(t);
            }
            result.add(item);
        }
        return result;
    }

    public  List<String> getDataFromFile(String path) {
        List<String> result = new ArrayList<>();
        FileInputStream fis = null;
        try {

            fis = new FileInputStream(path);
            String charset = getFilecharset(fis);
            // 防止路径乱码   如果utf-8 乱码  改GBK     eclipse里创建的txt  用UTF-8，在电脑上自己创建的txt  用GBK
            InputStreamReader isr = null;
            fis = new FileInputStream(path);
            isr = new InputStreamReader(fis, charset);
            BufferedReader br = new BufferedReader(isr);
            String line = "";
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }


//    public static void main(String[] args) {
//        String path = "C:\\Users\\41276\\Desktop\\121EXPORTTRADEINFO.txt";
//        try {
//            System.out.println(getFilecharset(new FileInputStream(new File(path))));
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//        }
//    }
   //判断编码格式方法
    private  static String getFilecharset(FileInputStream sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(sourceFile);
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset; //文件编码为 ANSI
            } else if (first3Bytes[0] == (byte) 0xFF
                    && first3Bytes[1] == (byte) 0xFE) {
                charset = "UTF-16LE"; //文件编码为 Unicode
                checked = true;
            } else if (first3Bytes[0] == (byte) 0xFE
                    && first3Bytes[1] == (byte) 0xFF) {
                charset = "UTF-16BE"; //文件编码为 Unicode big endian
                checked = true;
            } else if (first3Bytes[0] == (byte) 0xEF
                    && first3Bytes[1] == (byte) 0xBB
                    && first3Bytes[2] == (byte) 0xBF) {
                charset = "UTF-8"; //文件编码为 UTF-8
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    loc++;
                    if (read >= 0xF0)
                        break;
                    if (0x80 <= read && read <= 0xBF) // 单独出现BF以下的，也算是GBK
                        break;
                    if (0xC0 <= read && read <= 0xDF) {
                        read = bis.read();
                        if (0x80 <= read && read <= 0xBF) // 双字节 (0xC0 - 0xDF)
                            // (0x80
                            // - 0xBF),也可能在GB编码内
                            continue;
                        else
                            break;
                    } else if (0xE0 <= read && read <= 0xEF) {// 也有可能出错，但是几率较小
                        read = bis.read();
                        if (0x80 <= read && read <= 0xBF) {
                            read = bis.read();
                            if (0x80 <= read && read <= 0xBF) {
                                charset = "UTF-8";
                                break;
                            } else
                                break;
                        } else
                            break;
                    }
                }
            }
            bis.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static List<Map<String, Object>> unZip(String filePath){
        List<Map<String, Object>> result = new ArrayList<>();
        try {
            ZipFile zipFile = new ZipFile(filePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String name = zipFile.getName();
            int i = name.lastIndexOf(File.separator);
            name = name.substring(i + 1, i + 28);
            while (entries.hasMoreElements()){
                ZipEntry zipEntry = entries.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                InputStreamReader isr = new InputStreamReader(inputStream, "GBK");
                BufferedReader br = new BufferedReader(isr);
                try {
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        if(line != null && line.contains(",")){
                            result.add(getLine(line,name));
                        }
                    }
                }finally {
                    br.close();
                    isr.close();
                    zipEntry.clone();
                }
            }
            zipFile.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Map getLine(String line,String filename){
        Map  result = new HashMap();
        String [] colums = line.split(",");
        String[] keys = IReportServiceImpl.KEYS;

        for (int i = 0; i<keys.length;i++){
            result.put(keys[i],colums[i]);
        }
        result.put("filename",filename);
       return  result;
    }
}
