package com.timer;

import com.service.statistics.QueryStatisticsService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/24 15:42
 * @description：统计定时器
 * @modified By：
 * @version: 1.0
 */
@Component
public class QueryStatisticsTimer {

@Resource
private QueryStatisticsService queryStatisticsService;

    @Scheduled(fixedDelay = 1000 * 60 * 60, initialDelay = 10000)
    public void run() {
        Calendar calendar = Calendar.getInstance();

        calendar.add(Calendar.DATE, -1);

        queryStatisticsService.doStatisticsSave(calendar.getTime());
    }
}
