package com.controller;

import com.model.JsonResult;
import com.model.QueryStatisticsModel;
import com.service.statistics.QueryStatisticsService;
import com.util.DateUtil;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import javax.xml.crypto.Data;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/23 19:09
 * @description：
 * @modified By：
 * @version:
 */
@RequestMapping("/statistics")
@RestController
public class QueryStatisticsController {

    @Resource
    private QueryStatisticsService queryStatisticsService;

    @RequestMapping("/query")
    @Validated
    public JsonResult query(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull Date start, @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull Date end){


        List<QueryStatisticsModel> query = queryStatisticsService.query(new Timestamp(start.getTime()),new Timestamp(end.getTime()));

        return JsonResult.success(query);
    }
}
