package com.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/10/29 19:44
 * @description：数据源配置
 * @modified By：
 * @version: 1.0
 */
@Configuration
@MapperScan(basePackages = "com.mapper.report", sqlSessionFactoryRef = "sqlSessionFactory")
public class ReportDataSourceConfig {

    @Value("${db.driver}")
    private String driverClass;
    @Value("${db.minPoolSize}")
    private int minPoolSize;
    @Value("${db.maxPoolSize}")
    private int maxPoolSize;
    @Value("${data.source.jdbcUrl}")
    private String jdbcUrl;
    @Value("${data.source.username}")
    private String username;
    @Value("${data.source.password}")
    private String password;
    @Value("${mapper.location}")
    private String mapperLocations;
    @Value("${config-location}")
    private String mapperConfig;

    @Bean(name = "reportDataSource")
    @Primary
    public DataSource reportDatasource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.setUsername(username);
        config.setPassword(password);
        config.setMinimumIdle(minPoolSize);
        config.setMaximumPoolSize(maxPoolSize);
        return new HikariDataSource(config);
    }

    @Bean
    public DataSourceTransactionManager reporDatasourceTransactionManager(@Qualifier("reportDataSource") DataSource datasource) {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean(name = "sqlSessionFactory")
    public SqlSessionFactory sqlSessionFactory(@Qualifier("reportDataSource") DataSource dataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(mapperLocations));
//        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
                .getResource(mapperConfig));
        return sessionFactory.getObject();
    }
}
