package com.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/11/1 15:42
 * @description：获取本机IP的工具类
 * @modified By：
 * @version: 1.0
 */
public class IpUtil {
    /**
     * 02
     * 获得主机IP
     * 03
     * <p>
     * 04
     *
     * @return String
     * 05
     */

    public static boolean isWindowsOS() {

        boolean isWindowsOS = false;

        String osName = System.getProperty("os.name");

        if (osName.toLowerCase().indexOf("windows") > -1) {

            isWindowsOS = true;

        }

        return isWindowsOS;

    }


    public static  List<String>  getAllIP() {
        List<String> list = new ArrayList<>();
        try {
            if (isWindowsOS()) {
                InetAddress ip = InetAddress.getLocalHost();
                list.add(ip.getHostAddress());
                return list;
            }
            InetAddress ipAdd = null;

            Enumeration<NetworkInterface> netInterfaces = (Enumeration<NetworkInterface>) NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = (NetworkInterface) netInterfaces.nextElement();
                //----------特定情况，可以考虑用ni.getName判断
                //遍历所有ip
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {

                    ipAdd = (InetAddress) ips.nextElement();
                    list.add(ipAdd.getHostAddress());
                }


            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    /**
     * 16
     * 获取本机ip地址，并自动区分Windows还是linux操作系统
     * 17
     *
     * @return String
     * 18
     */

    public static String getLocalIP() {
        String sIP = "";
        InetAddress ip = null;
        try {
            //如果是Windows操作系统
            if (isWindowsOS()) {
                ip = InetAddress.getLocalHost();
            } else {//如果是Linux操作系统
                boolean bFindIP = false;
                Enumeration<NetworkInterface> netInterfaces = (Enumeration<NetworkInterface>) NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    if (bFindIP) {
                        break;
                    }
                    NetworkInterface ni = (NetworkInterface) netInterfaces.nextElement();
                    //----------特定情况，可以考虑用ni.getName判断
                    //遍历所有ip
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        ip = (InetAddress) ips.nextElement();
                        if (ip.isSiteLocalAddress() && !ip.isLoopbackAddress()   //127.开头的都是lookback地址
                                && ip.getHostAddress().indexOf(":") == -1) {
                            bFindIP = true;
                            break;
                        }

                    }


                }

            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        if (null != ip) {
            sIP = ip.getHostAddress();
        }
        return sIP;

    }

}
