package com.util;

import com.QgException;
import com.service.http.IHttpService;
import com.sun.jersey.api.client.ClientResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/11/1 10:34
 * @description：钉钉提醒
 * @modified By：
 * @version: 1.0
 */
@Component
@Slf4j
public class DingTalk {
    @Autowired
    private IHttpService iHttpService;
    public static final String talkUri = "https://alertserv-dataservice.quantgroup.cn/common/alert/dingtalk";
    public static final String webHook = "https://oapi.dingtalk.com/robot/send?access_token=e67bf66fe8022e408e2ebdd7d840c5656d5ab0549ad6a860d941edf2bdfa2491";


    @Async
    public void talk(String msgTitle, String msgContent) {
        Map<String, String> param = new HashMap<>();
        param.put("webhook", webHook);
        param.put("alarmLevel", "Warn");
        param.put("msgTitle", "数据上报：" + msgTitle);
        param.put("msgContent", msgContent);
//        param.put("toUsers", "15542661376,18612632691");
        String resp = iHttpService.post(talkUri, param);
        log.info("测试钉钉报警接口结果!resp:{}", resp);
    }

    @Async
    public void talk(String msgTitle, Exception e) {
        if (e == null) {
            return;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        Map<String, String> param = new HashMap<>();
        param.put("webhook", webHook);
        param.put("alarmLevel", "Warn");
        param.put("msgTitle", "数据上报：" + msgTitle);
        param.put("msgContent", sw.toString().length() > 500 ? sw.toString().substring(0, 499) : sw.toString());
//        param.put("toUsers", "15542661376,18612632691");
        String resp = iHttpService.post(talkUri, param);
        log.info("测试钉钉报警接口结果!resp:{}", resp);
    }

    @Async
    public void talk(String msgTitle, QgException e) {
        Map<String, String> param = new HashMap<>();
        param.put("webhook", webHook);
        param.put("alarmLevel", "Warn");
        param.put("msgTitle", "数据上报：" + msgTitle);
        param.put("msgContent", exceptionToString(e));
//        param.put("toUsers", "15542661376,18612632691");
        String resp = iHttpService.post(talkUri, param);
        log.info("测试钉钉报警接口结果!resp:{}", resp);
    }

    public String exceptionToString(QgException e) {
        return new StringBuffer()
                .append(e.alarm)
                .append(":")
                .append(e.message == null ? "" : (e.message.length() > 500 ? e.message.substring(0, 499) : e.message)).toString();
    }
}
