package com.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.WebResource.Builder;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;

import javax.net.ssl.*;
import javax.ws.rs.core.MediaType;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Map.Entry;

// 一个简单的jersey client封装
public class JerseyClient {
    // Client instances are expensive resources. It is recommended
    // a configured instance is reused for the creation of Web resources
    Client client = null;
    ClientConfig clientConfig = null;
    WebResource resource = null;
    Utils utils = null;

    public void setUtils(Utils utils) {
        this.utils = utils;
    }

    public JerseyClient(Integer timeOut) {
        try {
            // 处理SSL证书
            TrustManager[] trustManagers = new TrustManager[]{
                    new X509TrustManager() {
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        }

                        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        }
                    }
            };
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());

            this.clientConfig = new DefaultClientConfig();
            // 超时设定 查询接口建议设置10s 报送接口建议设置120s
            this.clientConfig.getProperties()
                    .put(ClientConfig.PROPERTY_CONNECT_TIMEOUT, timeOut);  //10s
            this.clientConfig.getProperties().put(
                    HTTPSProperties.PROPERTY_HTTPS_PROPERTIES,
                    new HTTPSProperties(new HostnameVerifier() {
                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    }, context)
            );
            // client
            this.client = Client.create(this.clientConfig);
            // resource
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public ClientResponse post(Map<String, String> headerMap,
                               Map<String, String> bodyMap, String uri) {
        this.resource = this.client.resource(uri);
        ClientResponse response = null;
        String body = null;
        Builder resourceBuilder = this.resource
                .accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON);
        // some header
        if (headerMap != null && !headerMap.isEmpty()) {
            //System.out.println("[] header:");
            //System.out.println(Utils.map2Json(headerMap));
            for (Entry<String, String> entry : headerMap.entrySet()) {
                resourceBuilder = resourceBuilder
                        .header(entry.getKey(), entry.getValue());
            }
        }

        // body
        if (bodyMap != null && !bodyMap.isEmpty()) {
            body = utils.map2Json(bodyMap).toString();
        } else {
            body = "{}";
        }
        //
        response = resourceBuilder.post(ClientResponse.class, body);
        return response;
    }

    public String post(Map<String, String> bodyMap, String uri) {
        this.resource = this.client.resource(uri);
        String response = null;
        String body = null;
        Builder resourceBuilder = this.resource
                .type(MediaType.APPLICATION_JSON);
        // body
        if (bodyMap != null && !bodyMap.isEmpty()) {
            body = utils.map2Json(bodyMap).toString();
        } else {
            body = "{}";
        }
        //
        response = resourceBuilder.post(String.class, body);
        return response;
    }

}
