package com.service.statistics.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.emums.Corporation;
import com.emums.DataSource;
import com.entity.jpa.QueryStatisticsEntry;
import com.google.common.collect.Lists;
import com.mapper.report.ZhjMapper;
import com.service.report.ReportService;
import com.service.statistics.GetReportAndSearchNum;
import com.util.DateUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/24 14:58
 * @description：中互金
 * @modified By：
 * @version: 1.0
 */
@Service
public class ZhjReportAndSearchNum implements GetReportAndSearchNum {

    @Resource
    private ZhjMapper zhjMapper;
    @Resource
    private ReportService reportService;

    @Override
    public List<QueryStatisticsEntry> getByDate(Date date) {

        Date start = DateUtil.getDate(date, DateUtil.YYYY_MM_DD);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        //增加一天
        calendar.add(Calendar.DATE, 1);

        Long gdXdReportNum = zhjMapper.getGdXdReportNum(start, calendar.getTime(),0);
        long gdXdSearchNum = zhjMapper.getGdXdSearchNum(start, calendar.getTime());
        QueryStatisticsEntry entry = new QueryStatisticsEntry();
        entry.setReportNum(gdXdReportNum == null ? 0L : gdXdReportNum);
        entry.setQueryQuantity(gdXdSearchNum);
        entry.setMaxQueryNum(0L);
        entry.setCorporation(Corporation.GUANGDAXIAODAI);

        /**
         * 如果是当月才回去查
         */
        if(DateUtil.formatterDate(date, DateUtil.YYYY_MM).equals(DateUtil.formatterDate(new Date(), DateUtil.YYYY_MM))){
            Map<String, String> resultMap = reportService.querycontral();

            if(resultMap.get("code").equals("200")){
                String data = resultMap.get("data");
                JSONObject parse = JSON.parseObject(data);
                String maxquerycount = parse.getString("maxquerycount");
                entry.setMaxQueryNum(Long.valueOf(maxquerycount));
            }
        }
        return Lists.newArrayList(entry);
    }

    @Override
    public DataSource getDataSource() {
        return DataSource.ZHJ;
    }
}
