package com.controller;

import com.emums.Corporation;
import com.emums.DataSource;
import com.model.JsonResult;
import com.model.QueryStatisticsModel;
import com.service.statistics.QueryStatisticsService;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/23 19:09
 * @description：
 * @modified By：
 * @version:
 */
@RequestMapping("/statistics")
@RestController
public class QueryStatisticsController {

    @Resource
    private QueryStatisticsService queryStatisticsService;

    @RequestMapping("/query")
    @Validated
    public JsonResult query(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull Date start,
                            @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @NotNull Date end,
                            DataSource source, Corporation corporation) {


        List<QueryStatisticsModel> query = queryStatisticsService.query(new Timestamp(start.getTime()), new Timestamp(end.getTime()));
        if (null != source) {
            query = query.stream().filter(o -> o.getDataSource() == source).collect(Collectors.toList());
        }
        if (null != corporation) {
            query = query.stream().filter(o -> o.getCorporation() == corporation).collect(Collectors.toList());
        }
        return JsonResult.success(query);
    }
}
